/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.editparts.FBEditPart;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseFactory;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.AdapterPortElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringAdapterElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringFactory;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.MonitoringManagerUtils;
import org.eclipse.fordiac.ide.monitoring.editparts.MonitoringAdapterInterfaceEditPart;
import org.eclipse.fordiac.ide.monitoring.handlers.AbstractMonitoringHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddWatchHandler
extends AbstractMonitoringHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            MonitoringManager manager = MonitoringManager.getInstance();
            Set<InterfaceEditPart> foundElements = AddWatchHandler.getSelectedWatchedelements(manager, (StructuredSelection)selection);
            for (InterfaceEditPart editPart : foundElements) {
                PortElement port = MonitoringManagerUtils.createPortElement(editPart);
                this.createMonitoringElement(manager, port);
            }
            this.refreshEditor();
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        boolean needToAdd = false;
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            needToAdd = !AddWatchHandler.getSelectedWatchedelements(MonitoringManager.getInstance(), (StructuredSelection)selection).isEmpty();
        }
        this.setBaseEnabled(needToAdd);
    }

    private static Set<InterfaceEditPart> getSelectedWatchedelements(MonitoringManager manager, StructuredSelection selection) {
        HashSet<InterfaceEditPart> foundElements = new HashSet<InterfaceEditPart>();
        for (Object selectedObject : selection) {
            InterfaceEditPart iEditPart;
            if (selectedObject instanceof FBEditPart) {
                if (!MonitoringManagerUtils.canBeMonitored((FBEditPart)selectedObject)) continue;
                foundElements.addAll(((FBEditPart)selectedObject).getChildren().stream().filter(element -> element instanceof InterfaceEditPart).collect(Collectors.toSet()));
                continue;
            }
            if (!(selectedObject instanceof InterfaceEditPart) || selectedObject instanceof MonitoringAdapterInterfaceEditPart || !MonitoringManagerUtils.canBeMonitored(iEditPart = (InterfaceEditPart)selectedObject) || manager.containsPort(iEditPart.getModel())) continue;
            foundElements.add(iEditPart);
        }
        return foundElements;
    }

    protected MonitoringBaseElement createMonitoringElement(MonitoringManager manager, PortElement port) {
        Object element = port instanceof AdapterPortElement ? MonitoringFactory.eINSTANCE.createMonitoringAdapterElement() : MonitoringFactory.eINSTANCE.createMonitoringElement();
        element.setPort(port);
        manager.addMonitoringElement((MonitoringBaseElement)element);
        if (port instanceof AdapterPortElement) {
            Object adpaterElement = element;
            this.createMonitoringElementsForAdapterInterface(manager, (MonitoringAdapterElement)adpaterElement);
        }
        return element;
    }

    private void createMonitoringElementsForAdapterInterface(MonitoringManager manager, MonitoringAdapterElement adpaterElement) {
        AddWatchHandler.createMonitoredAdpaterFBView(adpaterElement);
        this.refreshEditor();
        PortElement port = adpaterElement.getPort();
        EList<MonitoringElement> childElements = adpaterElement.getElements();
        InterfaceList interfaceList = adpaterElement.getMonitoredAdapterFB().getInterface();
        EList<PortElement> ports = ((AdapterPortElement)port).getPorts();
        ArrayList ios = new ArrayList();
        ios.addAll(interfaceList.getEventInputs());
        ios.addAll(interfaceList.getEventOutputs());
        ios.addAll(interfaceList.getInputVars());
        ios.addAll(interfaceList.getOutputVars());
        for (IInterfaceElement io : ios) {
            PortElement newPort = MonitoringBaseFactory.eINSTANCE.createPortElement();
            newPort.setFb(port.getFb());
            newPort.setInterfaceElement(io);
            newPort.setResource(port.getResource());
            ports.add(newPort);
            childElements.add((MonitoringElement)this.createMonitoringElement(manager, newPort));
        }
    }

    private static void createMonitoredAdpaterFBView(MonitoringAdapterElement adpaterElement) {
        AdapterFB fb = LibraryElementFactory.eINSTANCE.createAdapterFB();
        IInterfaceElement interfaceElement = adpaterElement.getPort().getInterfaceElement();
        Palette palette = interfaceElement.getFBNetworkElement().getFbNetwork().getAutomationSystem().getPalette();
        List types = palette.getTypeEntries(((AdapterDeclaration)interfaceElement).getType().getName());
        fb.setPaletteEntry((PaletteEntry)types.get(0));
        fb.setAdapterDecl((AdapterDeclaration)interfaceElement);
        fb.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        AddWatchHandler.createMonitoredAdapterInterface(fb);
        adpaterElement.setMonitoredAdapterFB(fb);
    }

    private static void createMonitoredAdapterInterface(AdapterFB fb) {
        InterfaceList interfaceList = fb.getInterface();
        for (Event event : fb.getType().getInterfaceList().getEventInputs()) {
            interfaceList.getEventInputs().add((Object)((Event)EcoreUtil.copy((EObject)event)));
        }
        for (Event event : fb.getType().getInterfaceList().getEventOutputs()) {
            interfaceList.getEventOutputs().add((Object)((Event)EcoreUtil.copy((EObject)event)));
        }
        for (VarDeclaration var : fb.getType().getInterfaceList().getInputVars()) {
            interfaceList.getInputVars().add((Object)((VarDeclaration)EcoreUtil.copy((EObject)var)));
        }
        for (VarDeclaration var : fb.getType().getInterfaceList().getOutputVars()) {
            interfaceList.getOutputVars().add((Object)((VarDeclaration)EcoreUtil.copy((EObject)var)));
        }
    }
}

