/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.draw2d;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.jface.preference.IPreferenceStore;

public class ConnectorBorder
extends AbstractBorder {
    private boolean highlight = false;
    private IInterfaceElement editPartModelOject;
    private int leftMargin;
    private int rightMargin;
    private int topMargin;
    private int bottomMargin;

    public ConnectorBorder(IInterfaceElement editPartModelOject) {
        this(editPartModelOject, false, 0, 0);
    }

    public ConnectorBorder(IInterfaceElement editPartModelOject, boolean highlight) {
        this(editPartModelOject, highlight, 0, 0);
    }

    public ConnectorBorder(IInterfaceElement editPartModelOject, boolean highlight, int topMargin, int bottomMargin) {
        this.highlight = highlight;
        this.editPartModelOject = editPartModelOject;
        if (this.isAdapter()) {
            this.leftMargin = 11;
            this.rightMargin = 11;
        } else {
            this.leftMargin = 5;
            this.rightMargin = 5;
        }
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
    }

    protected void createAdapterSymbol_MiniFBrotated(Graphics graphics, Rectangle where, int width, boolean filled) {
        graphics.setBackgroundColor(PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor"));
        graphics.setForegroundColor(PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor"));
        graphics.setLineWidth(1);
        graphics.setAntialias(1);
        PointList points = new PointList();
        int offest = 4;
        points.addPoint(width + where.x, where.y + offest);
        if (filled) {
            points.addPoint(width + where.x + 2, where.y + offest);
            points.addPoint(width + where.x + 2, where.y + offest + 2);
            points.addPoint(width + where.x + 4, where.y + offest + 2);
            points.addPoint(width + where.x + 4, where.y + offest);
            points.addPoint(width + where.x + 8, where.y + offest);
            points.addPoint(width + where.x + 8, where.y + offest + 8);
            points.addPoint(width + where.x + 4, where.y + offest + 8);
            points.addPoint(width + where.x + 4, where.y + offest + 6);
            points.addPoint(width + where.x + 2, where.y + offest + 6);
            points.addPoint(width + where.x + 2, where.y + offest + 8);
            points.addPoint(width + where.x, where.y + offest + 8);
            points.addPoint(width + where.x, where.y + offest);
            graphics.fillPolygon(points);
        } else {
            points.addPoint(width + where.x + 4, where.y + offest);
            points.addPoint(width + where.x + 4, where.y + offest + 2);
            points.addPoint(width + where.x + 6, where.y + offest + 2);
            points.addPoint(width + where.x + 6, where.y + offest);
            points.addPoint(width + where.x + 8, where.y + offest);
            points.addPoint(width + where.x + 8, where.y + offest + 7);
            points.addPoint(width + where.x + 6, where.y + offest + 7);
            points.addPoint(width + where.x + 6, where.y + offest + 5);
            points.addPoint(width + where.x + 4, where.y + offest + 5);
            points.addPoint(width + where.x + 4, where.y + offest + 7);
            points.addPoint(width + where.x, where.y + offest + 7);
            points.addPoint(width + where.x, where.y + offest);
            graphics.drawPolygon(points);
        }
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        if (this.isEvent()) {
            graphics.setForegroundColor(PreferenceGetter.getColor((String)"EventConnectionConnectorColor"));
            graphics.setBackgroundColor(PreferenceGetter.getColor((String)"EventConnectionConnectorColor"));
        } else if (this.isAdapter()) {
            graphics.setForegroundColor(PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor"));
            graphics.setBackgroundColor(PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor"));
        } else {
            graphics.setForegroundColor(PreferenceGetter.getColor((String)"DataConnectionConnectorColor"));
            graphics.setBackgroundColor(PreferenceGetter.getColor((String)"DataConnectionConnectorColor"));
        }
        Rectangle where = ConnectorBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
        Rectangle r = null;
        if (this.isInput()) {
            if (this.isAdapter()) {
                this.createAdapterSymbol_MiniFBrotated(graphics, where, 0, false);
            } else {
                r = new Rectangle(where.x, where.y + where.height / 2 - 1, 4, 4);
                graphics.fillRectangle(r);
            }
        } else if (this.isAdapter()) {
            this.createAdapterSymbol_MiniFBrotated(graphics, where, where.width - 9, true);
        } else {
            r = new Rectangle(where.width + where.x - 4, where.y + where.height / 2 - 1, 4, 4);
            graphics.fillRectangle(r);
        }
        if (this.highlight) {
            graphics.setForegroundColor(ColorConstants.gray);
            graphics.setBackgroundColor(ColorConstants.gray);
            IPreferenceStore pf = Activator.getDefault().getPreferenceStore();
            int cornerDim = pf.getInt("CornerDim");
            if (cornerDim > 1) {
                cornerDim /= 2;
            }
            Rectangle rect = ConnectorBorder.getPaintRectangle((IFigure)figure, (Insets)new Insets(0, 0, 1, 1));
            graphics.drawRoundRectangle(new Rectangle(rect.x, rect.y, rect.width, rect.height), cornerDim, cornerDim);
        }
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.topMargin, this.leftMargin, this.bottomMargin, this.rightMargin);
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public boolean isInput() {
        return this.editPartModelOject.isIsInput();
    }

    public boolean isEvent() {
        return this.editPartModelOject instanceof Event;
    }

    public boolean isAdapter() {
        return this.editPartModelOject instanceof AdapterDeclaration;
    }
}

