/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.editors;

import org.eclipse.fordiac.ide.ui.UIPlugin;
import org.eclipse.fordiac.ide.ui.editors.EditorAction;
import org.eclipse.fordiac.ide.ui.editors.EditorFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class EditorUtils {
    public static final EditorAction CloseEditor = part -> {
        boolean bl = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(part, false);
    };

    private EditorUtils() {
        throw new AssertionError();
    }

    public static IEditorPart getCurrentActiveEditor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null) {
            return window.getActivePage().getActiveEditor();
        }
        return null;
    }

    public static IEditorPart openEditor(IEditorInput input, String editorId) {
        IEditorPart editor = null;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            editor = activePage.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            editor = null;
            UIPlugin.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        return editor;
    }

    public static IEditorPart findEditor(EditorFilter filter) {
        IEditorReference[] editorReferences;
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor != null && filter.filter(editor)) {
                return editor;
            }
            ++n2;
        }
        return null;
    }

    public static void forEachOpenEditorFiltered(EditorFilter filter, EditorAction action) {
        IEditorReference[] editorReferences;
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor != null && filter.filter(editor)) {
                action.run(editor);
            }
            ++n2;
        }
    }

    public static void closeEditorsFiltered(EditorFilter filter) {
        EditorUtils.forEachOpenEditorFiltered(filter, CloseEditor);
    }
}

