/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeConditionEventCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteTransitionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.MoveBendpointCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.figures.ECTransitionFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies.TransitionBendPointEditPolicy;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.policies.FeedbackConnectionEndpointEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.util.STStringTokenHandling;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;

public class ECTransitionEditPart
extends AbstractConnectionEditPart {
    private static final int NORMAL_WIDTH = 2;
    private final EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            ECTransitionEditPart.this.refresh();
        }
    };
    private final EContentAdapter interfaceAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 4) {
                if (notification.getOldValue() == ECTransitionEditPart.this.getModel().getConditionEvent() || ECTransitionEditPart.this.getModel().getConditionEvent() instanceof AdapterEvent && notification.getOldValue() instanceof AdapterDeclaration && ((AdapterEvent)ECTransitionEditPart.this.getModel().getConditionEvent()).getAdapterDeclaration() == notification.getOldValue()) {
                    AbstractDirectEditableEditPart.executeCommand((Command)new ChangeConditionEventCommand(ECTransitionEditPart.this.getModel(), ""));
                }
            } else if (notification.getEventType() == 1) {
                if (ECTransitionEditPart.this.getModel().getConditionEvent() != null) {
                    this.handleCondiationEventUpdate(notification);
                }
                if (notification.getNotifier() instanceof VarDeclaration) {
                    this.checkConditionExpresion(notification);
                }
            }
        }

        private void handleCondiationEventUpdate(Notification notification) {
            if (notification.getNewValue() instanceof String) {
                String newValue = (String)notification.getNewValue();
                if (ECTransitionEditPart.this.getModel().getConditionEvent().getName().equals(newValue) || ECTransitionEditPart.this.getModel().getConditionEvent() instanceof AdapterEvent && ((AdapterEvent)ECTransitionEditPart.this.getModel().getConditionEvent()).getAdapterDeclaration().getName().equals(newValue)) {
                    super.notifyChanged(notification);
                    ECTransitionEditPart.this.refresh();
                }
            }
        }

        private void checkConditionExpresion(Notification notification) {
            if (notification.getNewValue() instanceof String) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature) && ECTransitionEditPart.this.getModel().getConditionExpression() != null && -1 != ECTransitionEditPart.this.getModel().getConditionExpression().indexOf(notification.getOldStringValue())) {
                    String expresion = STStringTokenHandling.replaceSTToken((String)ECTransitionEditPart.this.getModel().getConditionExpression(), (String)notification.getOldStringValue(), (String)notification.getNewStringValue());
                    ECTransitionEditPart.this.getModel().setConditionExpression(expresion);
                    ECTransitionEditPart.this.refresh();
                }
            }
        }
    };

    private void updateOrderLabel() {
        ECTransition transition = this.getModel();
        if (transition.getSource() != null) {
            if (1 < transition.getSource().getOutTransitions().size()) {
                int i = 1 + transition.getSource().getOutTransitions().indexOf((Object)transition);
                this.getConnectionFigure().setTransitionOrder(Integer.toString(i));
            } else {
                this.getConnectionFigure().setTransitionOrder("");
            }
        }
    }

    public ECTransition getModel() {
        return (ECTransition)super.getModel();
    }

    public ECTransitionFigure getConnectionFigure() {
        return (ECTransitionFigure)super.getConnectionFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new FeedbackConnectionEndpointEditPolicy(2, 5));
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new TransitionBendPointEditPolicy(this.getModel()));
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new DeleteTransitionCommand(ECTransitionEditPart.this.getModel());
            }
        });
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutEditPolicy(){

            public Command getCommand(Request request) {
                if ("move".equals(request.getType()) && request instanceof ChangeBoundsRequest) {
                    return this.getTransitionMoveCommand((ChangeBoundsRequest)request);
                }
                return null;
            }

            public boolean understandsRequest(Request request) {
                return "move".equals(request.getType());
            }

            private Command getTransitionMoveCommand(ChangeBoundsRequest request) {
                Point p = new Point(ECTransitionEditPart.this.getModel().getX(), ECTransitionEditPart.this.getModel().getY());
                double scaleFactor = ((ZoomScalableFreeformRootEditPart)ECTransitionEditPart.this.getRoot()).getZoomManager().getZoom();
                p.scale(scaleFactor);
                p.x += request.getMoveDelta().x;
                p.y += request.getMoveDelta().y;
                p.scale(1.0 / scaleFactor);
                return new MoveBendpointCommand(ECTransitionEditPart.this.getModel(), p);
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        });
    }

    public void performRequest(Request request) {
        if (request.getType() != "open") {
            super.performRequest(request);
        }
    }

    protected void refreshVisuals() {
        this.getConnectionFigure().setConditionText(this.getModel().getConditionText());
        this.getConnectionFigure().updateBendPoints(this.getModel());
        this.updateOrderLabel();
    }

    protected IFigure createFigure() {
        ECTransitionFigure figure = new ECTransitionFigure(this.getModel());
        figure.setLineWidth(2);
        return figure;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().eAdapters().add((Object)this.adapter);
            this.getModel().getECC().eAdapters().add((Object)this.adapter);
            this.getModel().getECC().getBasicFBType().getInterfaceList().eAdapters().add((Object)this.interfaceAdapter);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.adapter);
            this.getModel().getECC().eAdapters().remove((Object)this.adapter);
            this.getModel().getECC().getBasicFBType().getInterfaceList().eAdapters().remove((Object)this.interfaceAdapter);
        }
    }

    public void highlight(boolean highlight) {
        ECTransitionFigure pc = this.getConnectionFigure();
        if (pc != null) {
            pc.setLineWidth(highlight ? 3 : 2);
        }
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker((EditPart)this){

            protected boolean isMove() {
                if (this.getSourceEditPart() instanceof ECTransitionEditPart) {
                    return true;
                }
                return super.isMove();
            }
        };
    }
}

