/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.RenderingsUtil;

public class HexRendering
extends AbstractAsyncTableRendering {
    public HexRendering(String renderingId) {
        super(renderingId);
    }

    @Override
    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        StringBuilder strBuffer = new StringBuilder();
        String paddedStr = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
        int i = 0;
        while (i < data.length) {
            if (data[i].isReadable()) {
                strBuffer.append(new String(RenderingsUtil.convertByteToCharArray(data[i].getValue())));
            } else {
                strBuffer.append(paddedStr);
            }
            ++i;
        }
        return strBuffer.toString().toUpperCase();
    }

    @Override
    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        byte[] bytes = RenderingsUtil.convertHexStringToByteArray(data, currentValues.length, this.getNumCharsPerByte());
        return bytes;
    }

    @Override
    public int getNumCharsPerByte() {
        return 2;
    }
}

