/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppTImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SubAppNetworkImporter
extends FBNetworkImporter {
    public SubAppNetworkImporter(Palette palette) {
        super(palette);
    }

    public SubAppNetworkImporter(Palette palette, InterfaceList interfaceList) {
        super(palette, LibraryElementFactory.eINSTANCE.createFBNetwork(), interfaceList);
    }

    protected SubAppNetworkImporter(Palette palette, FBNetwork fbNetwork) {
        super(palette, fbNetwork);
    }

    @Override
    protected void parseFBNetworkEntryNode(Node n) throws TypeImportException {
        if (n.getNodeName().equals("SubApp")) {
            this.parseSubApp(n);
        } else {
            super.parseFBNetworkEntryNode(n);
        }
    }

    private void parseSubApp(Node node) throws TypeImportException {
        SubApp subApp = LibraryElementFactory.eINSTANCE.createSubApp();
        NamedNodeMap map = node.getAttributes();
        Node name = map.getNamedItem("Name");
        if (name == null) {
            throw new TypeImportException(Messages.SubAppTImporter_ERROR_SubAppName);
        }
        subApp.setName(name.getNodeValue());
        Node type = map.getNamedItem("Type");
        if (type != null) {
            this.configureSubAppInterface(subApp, node, type.getNodeValue());
        } else {
            this.parseUntypedSubapp(subApp, node.getChildNodes());
        }
        Node comment = map.getNamedItem("Comment");
        if (comment != null) {
            subApp.setComment(comment.getNodeValue());
        }
        CommonElementImporter.getXandY(map, subApp);
        SubAppNetworkImporter.configureParameters(subApp.getInterface(), node.getChildNodes());
        this.getFbNetwork().getNetworkElements().add((Object)subApp);
        this.fbNetworkElementMap.put(subApp.getName(), subApp);
    }

    private void configureSubAppInterface(SubApp subApp, Node node, String typeName) throws TypeImportException {
        PaletteEntry entry = this.getPalette().getTypeEntry(typeName);
        if (entry instanceof SubApplicationTypePaletteEntry) {
            subApp.setPaletteEntry(entry);
            SubApplicationTypePaletteEntry subEntry = (SubApplicationTypePaletteEntry)entry;
            subApp.setInterface((InterfaceList)EcoreUtil.copy((EObject)subEntry.getSubApplicationType().getInterfaceList()));
            SubAppNetworkImporter.configureParameters(subApp.getInterface(), node.getChildNodes());
        }
    }

    private void parseUntypedSubapp(SubApp subApp, NodeList subAppChildNodes) throws TypeImportException {
        int i = 0;
        while (i < subAppChildNodes.getLength()) {
            Node n = subAppChildNodes.item(i);
            switch (n.getNodeName()) {
                case "SubAppInterfaceList": {
                    SubAppTImporter interfaceImporter = new SubAppTImporter();
                    interfaceImporter.setPalette(this.getPalette());
                    subApp.setInterface(interfaceImporter.parseInterfaceList(n));
                    break;
                }
                case "SubAppNetwork": {
                    subApp.setSubAppNetwork(new SubAppNetworkImporter(this.getPalette(), subApp.getInterface()).parseFBNetwork(n));
                    break;
                }
            }
            ++i;
        }
    }
}

