/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.print;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;

class PrintMargin {
    private int left;
    private int right;
    private int top;
    private int bottom;

    private PrintMargin(int left, int right, int top, int bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    int getWidth() {
        return this.right - this.left;
    }

    int getHeight() {
        return this.bottom - this.top;
    }

    static PrintMargin getPrintMargin(Printer printer, double margin) {
        return PrintMargin.getPrintMargin(printer, margin, margin, margin, margin);
    }

    static PrintMargin getPrintMargin(Printer printer, double marginLeft, double marginRight, double marginTop, double marginBottom) {
        Rectangle clientArea = printer.getClientArea();
        Rectangle trim = printer.computeTrim(0, 0, 0, 0);
        Point dpi = printer.getDPI();
        int leftMargin = (int)(marginLeft * (double)dpi.x) - trim.x;
        int rightMargin = clientArea.width + trim.width - (int)(marginRight * (double)dpi.x) - trim.x;
        int topMargin = (int)(marginTop * (double)dpi.y) - trim.y;
        int bottomMargin = clientArea.height + trim.height - (int)(marginBottom * (double)dpi.y) - trim.y;
        return new PrintMargin(leftMargin, rightMargin, topMargin, bottomMargin);
    }

    public String toString() {
        return "Margin { " + this.left + ", " + this.right + "; " + this.top + ", " + this.bottom + " }";
    }
}

