/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.wizards;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.ApplicationPlugin;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.wizards.SaveAsSubappWizardPage;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class SaveAsSubappWizard
extends Wizard {
    private final SubApp subApp;
    private SaveAsSubappWizardPage newFilePage;

    public SaveAsSubappWizard(SubApp subApp) {
        this.setWindowTitle(Messages.SaveAsSubApplicationTypeAction_WizardTitle);
        this.subApp = subApp;
    }

    public void addPages() {
        IProject project = this.subApp.getSubAppNetwork().getAutomationSystem().getProject();
        StructuredSelection selection = new StructuredSelection((Object)project);
        this.newFilePage = new SaveAsSubappWizardPage(Messages.SaveAsSubApplicationTypeAction_WizardPageName, (IStructuredSelection)selection);
        this.newFilePage.setFileName(this.subApp.getName());
        this.addPage((IWizardPage)this.newFilePage);
    }

    public boolean performFinish() {
        boolean perform = true;
        IFile targetFile = this.getTargetTypeFile();
        if (targetFile.exists()) {
            perform = this.askOverwrite();
        }
        if (perform) {
            if (this.createSubAppTemplateCopy()) {
                PaletteEntry entry = this.getPalletEntry();
                LibraryElement type = entry.getType();
                type.setName(TypeLibrary.getTypeNameFromFile((IFile)entry.getFile()));
                TypeManagementPreferencesHelper.setupIdentification((LibraryElement)type);
                TypeManagementPreferencesHelper.setupVersionInfo((LibraryElement)type);
                this.performTypeSetup((SubAppType)type);
                AbstractTypeExporter.saveType((PaletteEntry)entry);
                entry.setType(type);
                if (this.newFilePage.getOpenType()) {
                    SaveAsSubappWizard.openTypeEditor(entry);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean askOverwrite() {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.SaveAsSubApplicationTypeAction_WizardOverrideTitle, (String)Messages.SaveAsSubApplicationTypeAction_WizardOverrideMessage);
    }

    private boolean createSubAppTemplateCopy() {
        String templateFolderPath = Platform.getInstallLocation().getURL().getFile();
        File templateFolder = new File(String.valueOf(templateFolderPath) + File.separatorChar + "template");
        File[] fileList = templateFolder.listFiles();
        if (fileList != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName().toUpperCase();
                if (fileName.endsWith("SUB")) {
                    IFile targetTypeFile = this.getTargetTypeFile();
                    try {
                        ImportUtils.copyFile((File)file, (IFile)targetTypeFile);
                        return true;
                    }
                    catch (IOException | CoreException e) {
                        ApplicationPlugin.getDefault().logError(e.getMessage(), (Exception)e);
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private IFile getTargetTypeFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.newFilePage.getContainerFullPath() + File.separator + this.newFilePage.getFileName() + ".SUB"));
    }

    private PaletteEntry getPalletEntry() {
        IFile targetTypeFile;
        Palette palette = this.subApp.getSubAppNetwork().getAutomationSystem().getPalette();
        PaletteEntry entry = TypeLibrary.getPaletteEntry((Palette)palette, (IFile)(targetTypeFile = this.getTargetTypeFile()));
        if (entry == null) {
            TypeLibrary.refreshPalette((Palette)palette);
            entry = TypeLibrary.getPaletteEntry((Palette)palette, (IFile)targetTypeFile);
        }
        return entry;
    }

    private static void openTypeEditor(PaletteEntry entry) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(entry.getFile().getName());
        EditorUtils.openEditor((IEditorInput)new FileEditorInput(entry.getFile()), (String)desc.getId());
    }

    private void performTypeSetup(SubAppType type) {
        this.performInterfaceSetup(type);
        type.setFBNetwork(FBNetworkHelper.copyFBNetWork((FBNetwork)this.subApp.getSubAppNetwork(), (InterfaceList)type.getInterfaceList()));
    }

    private void performInterfaceSetup(SubAppType type) {
        InterfaceList interfaceList = (InterfaceList)EcoreUtil.copy((EObject)this.subApp.getInterface());
        type.setInterfaceList(interfaceList);
    }
}

