/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.gef.figures.InteractionStyleFigure;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SegmentType;
import org.eclipse.fordiac.ide.systemconfiguration.policies.DeleteSegmentEditPolicy;
import org.eclipse.fordiac.ide.systemconfiguration.policies.SegmentNodeEditPolicy;
import org.eclipse.fordiac.ide.util.ColorHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class SegmentEditPart
extends AbstractViewEditPart
implements NodeEditPart {
    private ZoomManager zoomManager;
    private DiagramFontChangeListener fontChangeListener;

    public SegmentEditPart(ZoomManager zoomManager) {
        this.setConnectable(true);
        this.zoomManager = zoomManager;
    }

    public void activate() {
        super.activate();
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
    }

    public void deactivate() {
        super.deactivate();
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    protected IFigure createFigureForModel() {
        return new SegmentFigure();
    }

    public SegmentFigure getFigure() {
        return (SegmentFigure)super.getFigure();
    }

    protected EContentAdapter createContentAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getColorizableElement_Color().equals(feature)) {
                    SegmentEditPart.this.backgroundColorChanged((IFigure)SegmentEditPart.this.getFigure());
                }
                if (LibraryElementPackage.eINSTANCE.getPositionableElement_X().equals(feature) || LibraryElementPackage.eINSTANCE.getPositionableElement_Y().equals(feature) || LibraryElementPackage.eINSTANCE.getSegment_Width().equals(feature)) {
                    SegmentEditPart.this.refreshVisuals();
                }
                super.notifyChanged(notification);
                SegmentEditPart.this.refreshSourceConnections();
            }
        };
    }

    public Segment getModel() {
        return (Segment)super.getModel();
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    private SegmentFigure getCastedFigure() {
        return this.getFigure();
    }

    protected void backgroundColorChanged(IFigure figure) {
        Color fordiacColor = this.getModel().getColor();
        if (fordiacColor == null) {
            fordiacColor = ColorHelper.createRandomColor();
            this.getModel().setColor(fordiacColor);
        }
        this.setColor(figure, fordiacColor);
    }

    public Label getNameLabel() {
        return this.getCastedFigure().getName();
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        return null;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutEditPolicy(){

            public Command getCommand(Request request) {
                Object type = request.getType();
                if ("align".equals(type) && request instanceof AlignmentRequest) {
                    return this.getAlignCommand((AlignmentRequest)request);
                }
                return null;
            }

            protected Command getAlignCommand(AlignmentRequest request) {
                AlignmentRequest req = new AlignmentRequest((Object)"align children");
                req.setEditParts(this.getHost());
                req.setAlignment(request.getAlignment());
                req.setAlignmentRectangle(request.getAlignmentRectangle());
                return this.getHost().getParent().getCommand((Request)req);
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        });
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new SegmentNodeEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteSegmentEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshPosition();
    }

    protected void refreshPosition() {
        Rectangle bounds = new Rectangle(this.getModel().getX(), this.getModel().getY(), this.getModel().getWidth(), -1);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getFigure(), (Object)bounds);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    protected List<?> getModelSourceConnections() {
        return this.getModel().getOutConnections();
    }

    protected List<?> getModelTargetConnections() {
        return Collections.emptyList();
    }

    public class SegmentFigure
    extends Shape
    implements InteractionStyleFigure,
    IFontUpdateListener {
        private final Label instanceNameLabel;
        private final Label typeLabel;
        private final Figure main = new Figure();
        private final RoundedRectangle rect = new RoundedRectangle(){

            protected void outlineShape(Graphics graphics) {
            }

            protected void fillShape(Graphics graphics) {
                Display display = Display.getCurrent();
                Rectangle boundingRect = this.getBounds().getCopy();
                boundingRect.scale(SegmentEditPart.this.zoomManager.getZoom());
                Point topLeft = boundingRect.getTopLeft();
                Point bottomRight = boundingRect.getBottomRight();
                org.eclipse.swt.graphics.Color first = ColorHelper.lighter((org.eclipse.swt.graphics.Color)this.getBackgroundColor());
                Pattern pattern = new Pattern((Device)display, (float)topLeft.x, (float)(topLeft.y + boundingRect.height / 2), (float)topLeft.x, (float)bottomRight.y, this.getBackgroundColor(), first);
                graphics.setBackgroundPattern(pattern);
                graphics.fillRoundRectangle(this.getBounds(), this.getCornerDimensions().width, this.getCornerDimensions().height);
                graphics.setBackgroundPattern(null);
                pattern.dispose();
                org.eclipse.swt.graphics.Color darker = ColorHelper.darker((org.eclipse.swt.graphics.Color)this.getBackgroundColor());
                pattern = new Pattern((Device)display, (float)topLeft.x, (float)(topLeft.y + boundingRect.height / 2), (float)topLeft.x, (float)bottomRight.y, darker, this.getBackgroundColor());
                graphics.setBackgroundPattern(pattern);
                graphics.fillOval(this.getBounds().right() - this.getBounds().height() * 2 / 3, this.getBounds().getTop().y, this.getBounds().height() * 2 / 3, this.getBounds().height());
                graphics.setBackgroundPattern(null);
                pattern.dispose();
                pattern = new Pattern((Device)display, (float)topLeft.x, (float)(topLeft.y + this.getBounds().height / 2), (float)topLeft.x, (float)bottomRight.y, first, this.getBackgroundColor());
                graphics.setBackgroundPattern(pattern);
                Rectangle clipRect = this.getBounds().getCopy();
                clipRect.setHeight(clipRect.height / 2);
                clipRect.setY(clipRect.y + clipRect.height);
                graphics.clipRect(clipRect);
                graphics.fillRoundRectangle(this.getBounds(), this.getCornerDimensions().width, this.getCornerDimensions().height);
                graphics.setBackgroundPattern(null);
                pattern.dispose();
                first.dispose();
                graphics.clipRect(this.getBounds().getCopy());
                pattern = new Pattern((Device)display, (float)topLeft.x, (float)(topLeft.y + boundingRect.height / 2), (float)topLeft.x, (float)bottomRight.y, this.getBackgroundColor(), darker);
                graphics.setBackgroundPattern(pattern);
                graphics.fillOval(this.getBounds().right() - this.getBounds().height() * 2 / 3, this.getBounds().getTop().y, this.getBounds().height() * 2 / 3, this.getBounds().height());
                graphics.setBackgroundPattern(null);
                pattern.dispose();
                darker.dispose();
            }

            public void setBounds(Rectangle rect) {
                super.setBounds(rect);
                this.setCornerDimensions(new Dimension(rect.height * 2 / 3, rect.height));
            }
        };

        public SegmentFigure() {
            this.setFillXOR(true);
            this.setFill(true);
            GridData rectLayoutData = new GridData(768);
            GridData instanceNameLayout = new GridData(768);
            this.instanceNameLabel = new Label();
            this.instanceNameLabel.setText(SegmentEditPart.this.getINamedElement().getName());
            this.instanceNameLabel.setTextAlignment(4);
            this.instanceNameLabel.setLabelAlignment(4);
            GridLayout gridLayout = new GridLayout(1, true);
            gridLayout.verticalSpacing = 2;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.setLayoutManager((LayoutManager)gridLayout);
            GridLayout mainLayout = new GridLayout(3, false);
            mainLayout.marginHeight = 0;
            mainLayout.marginWidth = 0;
            mainLayout.horizontalSpacing = 0;
            mainLayout.verticalSpacing = -1;
            GridData mainLayoutData = new GridData(1808);
            this.main.setLayoutManager((LayoutManager)mainLayout);
            this.add((IFigure)this.main);
            this.setConstraint((IFigure)this.main, mainLayoutData);
            this.main.add((IFigure)this.rect);
            this.main.setConstraint((IFigure)this.rect, (Object)rectLayoutData);
            this.rect.add((IFigure)this.instanceNameLabel);
            this.instanceNameLabel.setBorder((Border)new MarginBorder(4, 0, 4, 0));
            GridLayout rectLayout = new GridLayout(3, false);
            rectLayout.marginHeight = 2;
            rectLayout.marginWidth = 0;
            this.rect.setLayoutManager((LayoutManager)rectLayout);
            this.rect.setConstraint((IFigure)this.instanceNameLabel, (Object)instanceNameLayout);
            this.rect.add((IFigure)new Label(":"));
            SegmentType type = SegmentEditPart.this.getModel().getType();
            String typeName = type != null ? type.getName() : "Type not set!";
            this.typeLabel = new Label(typeName);
            this.rect.add((IFigure)this.typeLabel);
            this.rect.setConstraint((IFigure)this.typeLabel, (Object)new GridData(544));
            this.typeLabel.setTextAlignment(1);
            this.typeLabel.setLabelAlignment(1);
            this.typeLabel.setBackgroundColor(ColorConstants.blue);
            this.typeLabel.setOpaque(false);
            this.setInstanceAndTypeLabelFonts();
        }

        public Label getName() {
            return this.instanceNameLabel;
        }

        protected void fillShape(Graphics graphics) {
        }

        protected void outlineShape(Graphics graphics) {
        }

        public int getIntersectionStyle(Point location) {
            if (this.instanceNameLabel.intersects(new Rectangle(location, new Dimension(1, 1)))) {
                return 1;
            }
            return 0;
        }

        public void updateFonts() {
            this.setInstanceAndTypeLabelFonts();
            this.invalidateTree();
            this.revalidate();
        }

        public void setInstanceAndTypeLabelFonts() {
            this.instanceNameLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
            this.typeLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
        }
    }
}

