/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteWithCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class WithEditPart
extends AbstractConnectionEditPart {
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
        }
    };

    public With getCastedModel() {
        return (With)this.getModel();
    }

    private boolean isInput() {
        With with = this.getCastedModel();
        if (with != null) {
            Event event = (Event)with.eContainer();
            if (event != null) {
                return event.isIsInput();
            }
            return false;
        }
        return false;
    }

    private int calculateInputWithPos() {
        With with = this.getCastedModel();
        Event event = (Event)with.eContainer();
        InterfaceList interfaceList = (InterfaceList)event.eContainer();
        int pos = interfaceList.getEventInputs().indexOf((Object)event) + 1;
        return pos;
    }

    private int calculateOutputWithPos() {
        With with = this.getCastedModel();
        Event event = (Event)with.eContainer();
        InterfaceList interfaceList = (InterfaceList)event.eContainer();
        int pos = interfaceList.getEventOutputs().indexOf((Object)event) + 1;
        return pos;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new DeleteWithCommand(WithEditPart.this.getCastedModel());
            }
        });
    }

    protected IFigure createFigure() {
        PolylineConnection connection = (PolylineConnection)super.createFigure();
        this.updateConnection(connection);
        return connection;
    }

    private void updateConnection(PolylineConnection connection) {
        int h = 15;
        float scale = 0.2f;
        PointList rect = new PointList();
        rect.addPoint(-h, -h);
        rect.addPoint(-h, h);
        rect.addPoint(h, h);
        rect.addPoint(h, -h);
        rect.addPoint(-h, -h);
        rect.addPoint(0, -h);
        if (this.isInput()) {
            rect.addPoint(0, -h - 45);
            rect.addPoint(0, h + 45 * this.calculateInputWithPos());
        } else {
            rect.addPoint(0, -h - 45 * this.calculateOutputWithPos());
            rect.addPoint(0, h + 45);
        }
        rect.addPoint(0, -h);
        PointList targetRect = new PointList();
        targetRect.addPoint(-h, -h);
        targetRect.addPoint(-h, h);
        targetRect.addPoint(h, h);
        targetRect.addPoint(h, -h);
        targetRect.addPoint(-h, -h);
        targetRect.addPoint(0, -h);
        if (this.isInput()) {
            targetRect.addPoint(0, -h - 45 * this.calculateInputWithPos());
            targetRect.addPoint(0, h + 45);
        } else {
            targetRect.addPoint(0, -h - 45);
            targetRect.addPoint(0, h + 45 * this.calculateOutputWithPos());
        }
        targetRect.addPoint(0, -h);
        PolygonDecoration rectDec = new PolygonDecoration();
        rectDec.setTemplate(targetRect.getCopy());
        rectDec.setScale((double)scale, (double)scale);
        rectDec.setFill(false);
        connection.setTargetDecoration((RotatableDecoration)rectDec);
        PolygonDecoration rectDec2 = new PolygonDecoration();
        rectDec2.setTemplate(rect.getCopy());
        rectDec2.setScale((double)scale, (double)scale);
        rectDec2.setFill(false);
        connection.setSourceDecoration((RotatableDecoration)rectDec2);
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void updateWithPos() {
        if (this.getCastedModel().eContainer() != null) {
            this.updateConnection((PolylineConnection)this.getFigure());
            this.refreshSourceAnchor();
            this.refreshTargetAnchor();
        }
    }
}

