/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.editparts.AbstractConnectableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.editparts.NameCellEditorLocator;
import org.eclipse.fordiac.ide.gef.policies.INamedElementRenameEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;

public abstract class AbstractDirectEditableEditPart
extends AbstractConnectableEditPart {
    private DirectEditManager manager;
    private final EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature)) {
                AbstractDirectEditableEditPart.this.refreshName();
            }
            super.notifyChanged(notification);
        }
    };

    protected EContentAdapter getNameAdapter() {
        return this.adapter;
    }

    public void refreshName() {
        this.getNameLabel().setText(this.getINamedElement().getName());
    }

    public abstract INamedElement getINamedElement();

    public void activate() {
        super.activate();
        if (this.getINamedElement() != null) {
            this.getINamedElement().eAdapters().add((Object)this.adapter);
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.getINamedElement() != null) {
            this.getINamedElement().eAdapters().remove((Object)this.adapter);
        }
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new INamedElementRenameEditPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    public DirectEditManager getManager() {
        if (this.manager == null) {
            this.manager = this.createDirectEditManager();
        }
        return this.manager;
    }

    protected DirectEditManager createDirectEditManager() {
        Label l = this.getNameLabel();
        return new LabelDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new NameCellEditorLocator(l), l);
    }

    public abstract Label getNameLabel();

    public void performDirectEdit() {
        this.getManager().show();
    }

    public static void executeCommand(Command cmd) {
        Object viewer = EditorUtils.getCurrentActiveEditor().getAdapter(GraphicalViewer.class);
        if (viewer instanceof GraphicalViewer) {
            ((GraphicalViewer)viewer).getEditDomain().getCommandStack().execute(cmd);
        } else {
            cmd.execute();
        }
    }
}

