/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.policies;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.systemconfiguration.commands.ResourceCreateCommand;
import org.eclipse.fordiac.ide.systemconfiguration.commands.ResourceMoveCommand;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.ResourceContainerEditPart;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.ResourceEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.preference.IPreferenceStore;

public class ResourceContainerLayoutEditPolicy
extends FlowLayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        IPreferenceStore pf = Activator.getDefault().getPreferenceStore();
        int cornerDim = pf.getInt("CornerDim");
        if (cornerDim > 1) {
            cornerDim /= 2;
        }
        return new ModifiedNonResizeableEditPolicy(cornerDim, new Insets(1));
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        return this.getMoveCommand(child, after);
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (request == null) {
            return null;
        }
        Object childClass = request.getNewObjectType();
        if (childClass instanceof ResourceTypeEntry) {
            ResourceTypeEntry type = (ResourceTypeEntry)request.getNewObjectType();
            if (this.getHost() instanceof ResourceContainerEditPart) {
                ResourceContainerEditPart resContainerEditPart = (ResourceContainerEditPart)this.getHost();
                EditPart ref = this.getInsertionReference((Request)request);
                int index = -1;
                if (ref != null) {
                    index = resContainerEditPart.getModel().getDevice().getResource().indexOf((Object)((ResourceEditPart)ref).getModel());
                }
                return new ResourceCreateCommand(type, resContainerEditPart.getModel().getDevice(), index, false);
            }
        }
        return null;
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        return this.getMoveCommand(child, after);
    }

    private ResourceMoveCommand getMoveCommand(EditPart child, EditPart after) {
        ResourceMoveCommand cmd = null;
        if (child instanceof ResourceEditPart && this.getHost() instanceof ResourceContainerEditPart) {
            int index = -1;
            Device targetDevice = ((ResourceContainerEditPart)this.getHost()).getModel().getDevice();
            index = after == null ? targetDevice.getResource().size() : targetDevice.getResource().indexOf(after.getModel());
            cmd = new ResourceMoveCommand((Resource)child.getModel(), targetDevice, index);
        }
        return cmd;
    }
}

