/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;

public class DeleteFBTypeParticipant
extends DeleteParticipant {
    private List<String> typeNames = new ArrayList<String>();

    protected boolean initialize(Object element) {
        return element instanceof IFile;
    }

    public String getName() {
        return "Delete IEC 61499 Type";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        ResourceChangeChecker resChecker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = resChecker.getDeltaFactory();
        IResourceDelta[] affectedChildren = deltaFactory.getDelta().getAffectedChildren();
        return this.verifyAffectedChildren(affectedChildren);
    }

    private RefactoringStatus verifyAffectedChildren(IResourceDelta[] affectedChildren) {
        IResourceDelta[] iResourceDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta resourceDelta = iResourceDeltaArray[n2];
            if (resourceDelta.getResource() instanceof IFile) {
                Palette palette = SystemManager.INSTANCE.getPalette(resourceDelta.getResource().getProject());
                this.typeNames.clear();
                String typeNameToDelete = TypeLibrary.getTypeNameFromFile((IFile)((IFile)resourceDelta.getResource()));
                this.checkTypeContainment(palette.getRootGroup(), typeNameToDelete);
                if (!this.typeNames.isEmpty()) {
                    return RefactoringStatus.createWarningStatus((String)("FB type " + typeNameToDelete + " is used in the following types: " + this.typeNames.toString()));
                }
            } else {
                return this.verifyAffectedChildren(resourceDelta.getAffectedChildren());
            }
            ++n2;
        }
        return new RefactoringStatus();
    }

    private void checkTypeContainment(PaletteGroup rootGroup, String searchTypeName) {
        for (PaletteEntry entry : rootGroup.getEntries()) {
            FBNetwork network = null;
            if (entry.getType() instanceof CompositeFBType) {
                network = ((CompositeFBType)entry.getType()).getFBNetwork();
            } else if (entry.getType() instanceof ResourceType) {
                network = ((ResourceType)entry.getType()).getFBNetwork();
            } else if (entry.getType() instanceof SubAppType) {
                network = ((SubAppType)entry.getType()).getFBNetwork();
            }
            if (network == null || !DeleteFBTypeParticipant.containsElementWithType(searchTypeName, network)) continue;
            this.typeNames.add(entry.getLabel());
        }
        for (PaletteGroup group : rootGroup.getSubGroups()) {
            this.checkTypeContainment(group, searchTypeName);
        }
    }

    private static boolean containsElementWithType(String searchTypeName, FBNetwork network) {
        for (FBNetworkElement element : network.getNetworkElements()) {
            if (!searchTypeName.equals(element.getTypeName())) continue;
            return true;
        }
        return false;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }
}

