/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeConditionEventCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeConditionExpressionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeECTransitionCommentCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ECCContentAndLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AbstractECSection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class TransitionSection
extends AbstractECSection {
    private static final String LINKING_FILE_EXTENSION = "xtextfbt";
    private Text commentText;
    private CCombo eventCombo;
    private Composite conditionEditingContainer;
    private CLabel closingBracket;
    private EmbeddedEditor editor;
    private Composite composite;
    @Inject
    private EmbeddedEditorFactory editorFactory;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    @Named(value="file.extensions")
    private String fileExtension;
    private EmbeddedEditorModelAccess embeddedEditorModelAccess;
    private final IDocumentListener listener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            TransitionSection.this.executeCommand(new ChangeConditionExpressionCommand(TransitionSection.this.getType(), TransitionSection.this.embeddedEditorModelAccess.getEditablePart()));
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };

    protected ECTransition getType() {
        return (ECTransition)this.type;
    }

    protected BasicFBType getBasicFBType() {
        return this.getType().getECC() != null ? this.getType().getECC().getBasicFBType() : null;
    }

    protected Object getInputType(Object input) {
        if (input instanceof EditPart) {
            input = ((EditPart)input).getModel();
        }
        if (input instanceof ECTransition) {
            return input;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        this.composite = this.getWidgetFactory().createComposite(parent);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(this.composite, "Condition:");
        this.createConditionEditingPlaceHolder(this.composite);
        this.getWidgetFactory().createCLabel(this.composite, "Comment:");
        this.commentText = this.createGroupText(this.composite, true);
        this.commentText.addModifyListener(event -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangeECTransitionCommentCommand(this.getType(), this.commentText.getText()));
            this.addContentAdapter();
        });
    }

    private void createConditionEditingPlaceHolder(Composite parent) {
        this.conditionEditingContainer = this.getWidgetFactory().createComposite(parent);
        this.conditionEditingContainer.setLayout((Layout)new GridLayout(4, false));
        GridData compositeLayoutData = new GridData(4, 0, true, false);
        compositeLayoutData.verticalIndent = 0;
        this.conditionEditingContainer.setLayoutData((Object)compositeLayoutData);
        this.eventCombo = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)this.conditionEditingContainer);
        this.eventCombo.addListener(13, event -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangeConditionEventCommand(this.getType(), this.eventCombo.getText()));
            this.checkEnablement();
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(this.conditionEditingContainer, "[");
        this.closingBracket = this.getWidgetFactory().createCLabel(this.conditionEditingContainer, "]");
    }

    protected void setInputInit() {
        if (this.editor == null) {
            this.createTransitionEditor(this.conditionEditingContainer);
        }
    }

    protected void setInputCode() {
        this.commentText.setEnabled(false);
        this.eventCombo.removeAll();
        this.eventCombo.setEnabled(false);
    }

    private void createTransitionEditor(Composite parent) {
        BasicFBType fbType = this.getBasicFBType();
        IEditedResourceProvider resourceProvider = new IEditedResourceProvider((FBType)fbType){
            private final /* synthetic */ FBType val$fbType;
            {
                this.val$fbType = fBType;
            }

            public XtextResource createResource() {
                XtextResourceSet resourceSet = (XtextResourceSet)TransitionSection.this.resourceSetProvider.get();
                EcoreUtil.Copier copier = new EcoreUtil.Copier();
                Resource fbResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, TransitionSection.LINKING_FILE_EXTENSION));
                fbResource.getContents().add((Object)copier.copy(EcoreUtil.getRootContainer((EObject)this.val$fbType)));
                for (AdapterDeclaration adapter : this.val$fbType.getInterfaceList().getSockets()) {
                    this.createAdapterResource(resourceSet, copier, adapter);
                }
                for (AdapterDeclaration adapter : this.val$fbType.getInterfaceList().getPlugs()) {
                    this.createAdapterResource(resourceSet, copier, adapter);
                }
                copier.copyReferences();
                Resource resource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, TransitionSection.this.fileExtension));
                return (XtextResource)resource;
            }

            private void createAdapterResource(XtextResourceSet resourceSet, EcoreUtil.Copier copier, AdapterDeclaration adapter) {
                Resource adapterResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, TransitionSection.LINKING_FILE_EXTENSION));
                copier.copy((EObject)adapter.getType());
                adapterResource.getContents().add((Object)copier.copy(EcoreUtil.getRootContainer((EObject)adapter.getType().getAdapterFBType())));
            }

            protected URI computeUnusedUri(ResourceSet resourceSet, String fileExtension) {
                String name = "__synthetic";
                int i = 0;
                while (i < Integer.MAX_VALUE) {
                    URI syntheticUri = URI.createURI((String)(String.valueOf(name) + i + "." + fileExtension));
                    if (resourceSet.getResource(syntheticUri, false) == null) {
                        return syntheticUri;
                    }
                    ++i;
                }
                throw new IllegalStateException();
            }
        };
        this.editor = this.editorFactory.newEditor(resourceProvider).withParent(parent);
        StyledText conditionText = (StyledText)this.editor.getViewer().getControl();
        conditionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        conditionText.moveAbove((Control)this.closingBracket);
        this.embeddedEditorModelAccess = this.editor.createPartialEditor();
        this.editor.getDocument().addDocumentListener(this.listener);
        this.composite.layout();
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null && this.getBasicFBType() != null) {
            this.setEventConditionDropdown();
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            this.updateConditionExpressionText(this.getType().getConditionExpression());
            if (this.getType().getConditionExpression() != null && this.getType().getConditionExpression().equals("1")) {
                this.eventCombo.select(this.eventCombo.indexOf("1"));
            } else {
                this.eventCombo.select(this.getType().getConditionEvent() != null ? this.eventCombo.indexOf(this.getType().getConditionEvent().getName()) : this.eventCombo.getItemCount() - 1);
            }
            this.checkEnablement();
        }
        this.commandStack = commandStackBuffer;
    }

    private void updateConditionExpressionText(String conditionExpression) {
        if (this.embeddedEditorModelAccess != null) {
            this.embeddedEditorModelAccess.updateModel(conditionExpression != null ? conditionExpression : "");
        }
    }

    private void checkEnablement() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.getType().getConditionExpression() != null && this.getType().getConditionExpression().equals("1")) {
            this.updateConditionExpressionText("");
            this.editor.getViewer().getControl().setEnabled(false);
        } else {
            this.editor.getViewer().getControl().setEnabled(true);
        }
        this.commandStack = commandStackBuffer;
    }

    public void setEventConditionDropdown() {
        this.eventCombo.removeAll();
        ECCContentAndLabelProvider.getTransitionConditionEventNames(this.getBasicFBType()).stream().forEach(name -> this.eventCombo.add(name));
    }
}

