/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.List;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.FBNetworkExporter;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.OtherAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class FbtExporter
extends AbstractTypeExporter {
    FbtExporter(FBTypePaletteEntry entry) {
        super(entry.getFBType());
    }

    @Override
    protected String getRootTag() {
        return "FBType";
    }

    @Override
    protected void createTypeSpecificXMLEntries(Element rootElement) {
        if (this.getType() instanceof CompositeFBType) {
            FBNetworkExporter nwExporter = new FBNetworkExporter(this.getDom());
            rootElement.appendChild(nwExporter.createFBNetworkElement(((CompositeFBType)this.getType()).getFBNetwork()));
        } else if (this.getType() instanceof BasicFBType) {
            this.addBasicFB(rootElement, (BasicFBType)this.getType());
        } else if (this.getType() instanceof SimpleFBType) {
            this.addSimpleFB(rootElement, (SimpleFBType)this.getType());
        }
    }

    private void addBasicFB(Element rootEle, BasicFBType type) {
        Element basicElement = this.createElement("BasicFB");
        this.addVarList(basicElement, (List<VarDeclaration>)type.getInternalVars(), "InternalVars");
        this.addECC(basicElement, type.getECC());
        type.getAlgorithm().forEach(alg -> this.addAlgorithm(basicElement, (Algorithm)alg));
        rootEle.appendChild(basicElement);
    }

    private void addOtherAlgorithm(Element algorithmElement, OtherAlgorithm algorithm) {
        Element st = this.createElement("Other");
        if (algorithm.getLanguage() != null) {
            st.setAttribute("Language", algorithm.getLanguage());
        } else {
            st.setAttribute("Language", "");
        }
        if (algorithm.getText() != null) {
            st.setAttribute("Text", algorithm.getText());
        } else {
            st.setAttribute("Text", "");
        }
        algorithmElement.appendChild(st);
    }

    private void addSTAlgorithm(Element algorithmElement, STAlgorithm algorithm) {
        Element st = this.createElement("ST");
        if (algorithm.getText() != null) {
            st.setAttribute("Text", algorithm.getText());
        } else {
            st.setAttribute("Text", "");
        }
        algorithmElement.appendChild(st);
    }

    private void addECC(Element basicElement, ECC ecc) {
        Element eccElement = this.createElement("ECC");
        if (ecc != null) {
            this.addECStates(eccElement, (List<ECState>)ecc.getECState(), ecc.getStart());
            ecc.getECTransition().forEach(transition -> {
                Node node = eccElement.appendChild(this.createTransitionEntry((ECTransition)transition));
            });
        }
        basicElement.appendChild(eccElement);
    }

    private Element createTransitionEntry(ECTransition transition) {
        Element transElement = this.createElement("ECTransition");
        transElement.setAttribute("Source", transition.getSource().getName());
        transElement.setAttribute("Destination", transition.getDestination().getName());
        transElement.setAttribute("Condition", transition.getConditionText());
        transElement.setAttribute("Comment", transition.getComment());
        CommonElementExporter.exportXandY(transition, transElement);
        return transElement;
    }

    private void addECStates(Element eccElement, List<ECState> states, ECState startState) {
        eccElement.appendChild(this.createECState(startState));
        states.forEach(state -> {
            if (!state.equals(startState)) {
                eccElement.appendChild(this.createECState((ECState)state));
            }
        });
    }

    private Element createECState(ECState state) {
        Element stateElement = this.createElement("ECState");
        FbtExporter.setNameAttribute(stateElement, state.getName());
        FbtExporter.setCommentAttribute(stateElement, state);
        CommonElementExporter.exportXandY(state, stateElement);
        this.addECActions(stateElement, (List<ECAction>)state.getECAction());
        return stateElement;
    }

    private void addECActions(Element stateElement, List<ECAction> actions) {
        for (ECAction action : actions) {
            Element actionElement = this.createElement("ECAction");
            if (action.getAlgorithm() != null) {
                actionElement.setAttribute("Algorithm", action.getAlgorithm().getName());
            }
            if (action.getOutput() != null) {
                actionElement.setAttribute("Output", action.getOutput().getName());
            }
            stateElement.appendChild(actionElement);
        }
    }

    private void addSimpleFB(Element rootEle, SimpleFBType type) {
        Element simpleElement = this.createElement("SimpleFB");
        this.addVarList(simpleElement, (List<VarDeclaration>)type.getInternalVars(), "InternalVars");
        this.addAlgorithm(simpleElement, type.getAlgorithm());
        rootEle.appendChild(simpleElement);
    }

    private void addAlgorithm(Element basicElement, Algorithm algorithm) {
        Element algorithmElement = this.createElement("Algorithm");
        FbtExporter.setNameAttribute(algorithmElement, algorithm.getName());
        FbtExporter.setCommentAttribute(algorithmElement, algorithm);
        if (algorithm instanceof STAlgorithm) {
            this.addSTAlgorithm(algorithmElement, (STAlgorithm)algorithm);
        } else if (algorithm instanceof OtherAlgorithm) {
            this.addOtherAlgorithm(algorithmElement, (OtherAlgorithm)algorithm);
        }
        basicElement.appendChild(algorithmElement);
    }
}

