/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.text.ParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.CompilableElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SegmentType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SEGImporter {
    public static SegmentType importSEGType(IFile iFile) {
        if (iFile.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            try {
                dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(iFile.getContents());
                Element rootNode = document.getDocumentElement();
                SegmentType type = LibraryElementFactory.eINSTANCE.createSegmentType();
                return SEGImporter.parseSEGType(type, rootNode);
            }
            catch (Exception e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        return null;
    }

    private static SegmentType parseSEGType(SegmentType type, Node rootNode) throws TypeImportException, ParseException {
        if (rootNode.getNodeName().equals("SegmentType")) {
            Node comment;
            NamedNodeMap map = rootNode.getAttributes();
            Node name = map.getNamedItem("Name");
            if (name != null) {
                type.setName(name.getNodeValue());
            }
            if ((comment = map.getNamedItem("Comment")) != null) {
                type.setComment(comment.getNodeValue());
            }
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("Identification")) {
                    type.setIdentification(CommonElementImporter.parseIdentification(type, n));
                }
                if (n.getNodeName().equals("VersionInfo")) {
                    type.getVersionInfo().add((Object)CommonElementImporter.parseVersionInfo(type, n));
                }
                if (n.getNodeName().equals("CompilerInfo")) {
                    type.setCompilerInfo(CompilableElementImporter.parseCompilerInfo(type, n));
                }
                if (n.getNodeName().equals("VarDeclaration")) {
                    VarDeclaration v = ImportUtils.parseVarDeclaration(n);
                    v.setIsInput(true);
                    type.getVarDeclaration().add((Object)v);
                }
                ++i;
            }
            return type;
        }
        throw new ParseException(Messages.FBTImporter_PARSE_FBTYPE_PARSEEXCEPTION, 0);
    }

    private SEGImporter() {
        throw new UnsupportedOperationException("SEGImporter utility class should not be instantiated!");
    }
}

