/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import org.eclipse.xtext.util.ITextRegion;

public class TextRegion
implements ITextRegion {
    private final int offset;
    private final int length;

    public TextRegion(int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset " + offset + " is < 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length " + length + " is < 0");
        }
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ITextRegion merge(ITextRegion other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        int newOffset = Math.min(this.offset, other.getOffset());
        int newLength = Math.max(this.offset + this.length, other.getOffset() + other.getLength()) - newOffset;
        return new TextRegion(newOffset, newLength);
    }

    @Override
    public boolean contains(ITextRegion other) {
        return other == EMPTY_REGION || other.getOffset() + other.getLength() <= this.offset + this.length && other.getOffset() >= this.offset;
    }

    @Override
    public boolean contains(int offset) {
        return offset >= this.offset && offset < this.offset + this.length;
    }

    public boolean equals(Object obj) {
        return obj instanceof ITextRegion && ((ITextRegion)obj).getOffset() == this.offset && ((ITextRegion)obj).getLength() == this.length;
    }

    public int hashCode() {
        return this.offset - 37 * this.length;
    }

    public String toString() {
        return "[" + this.offset + ":" + this.length + "]";
    }
}

