/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.runtime.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.runtime.Activator;
import org.eclipse.fordiac.ide.runtime.IRuntimeLauncher;
import org.eclipse.fordiac.ide.runtime.LaunchParameter;
import org.eclipse.fordiac.ide.runtime.LaunchRuntimeException;
import org.eclipse.fordiac.ide.runtime.views.RuntimeModifyListener;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;

public class RuntimeLauncherView
extends ViewPart {
    private static final String VALUES = "values";
    private IMemento memento;
    private final List<IRuntimeLauncher> launchers = new ArrayList<IRuntimeLauncher>();
    private final Map<String, Combo> comboTable = new HashMap<String, Combo>();

    public void createPartControl(Composite parent) {
        IConfigurationElement[] elems;
        GridLayout parentLayout = new GridLayout(1, false);
        parent.setLayout((Layout)parentLayout);
        IConfigurationElement[] iConfigurationElementArray = elems = RuntimeLauncherView.getRuntimeLaunchers();
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IRuntimeLauncher) {
                    IRuntimeLauncher launcher = (IRuntimeLauncher)object;
                    this.launchers.add(launcher);
                    this.createRuntimeLauncherGroupUI(parent, launcher);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError("Error loading Export Filter", (Exception)((Object)corex));
            }
            ++n2;
        }
        this.initFields();
    }

    private void createRuntimeLauncherGroupUI(Composite parent, IRuntimeLauncher launcher) {
        Group launcherGroup = new Group(parent, 4);
        launcherGroup.setText(launcher.getName());
        launcherGroup.setLayout((Layout)new GridLayout(3, false));
        launcherGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        List<LaunchParameter> params = launcher.getParams();
        boolean launchButton = true;
        int j = 0;
        while (j < launcher.getNumParameters()) {
            Label paramName = new Label((Composite)launcherGroup, 64);
            paramName.setText(params.get(j).getName());
            int style = 2048;
            if (params.get(j).isFixedValues()) {
                style |= 8;
            }
            Combo paramValue = new Combo((Composite)launcherGroup, style);
            if (params.get(j).isFixedValues()) {
                int k = 0;
                while (k < params.get(j).getValues().length) {
                    String deviceString = params.get(j).getValues()[k];
                    paramValue.add(deviceString);
                    ++k;
                }
            } else {
                paramValue.add(params.get(j).getValue());
            }
            GridData textAreaData = new GridData();
            textAreaData.horizontalAlignment = 4;
            textAreaData.grabExcessHorizontalSpace = true;
            paramValue.setLayoutData((Object)textAreaData);
            paramValue.addModifyListener((ModifyListener)new RuntimeModifyListener(launcher, paramName.getText()){

                @Override
                public void modifyText(ModifyEvent e) {
                    this.getLauncher().setParam(this.getName(), ((Combo)e.getSource()).getText());
                }
            });
            this.comboTable.put(String.valueOf(launcher.getName()) + "." + paramName.getText(), paramValue);
            if (launchButton) {
                this.createLaunchButton(launcher, launcherGroup);
                launchButton = false;
            }
            ++j;
        }
        this.createConfiguredRuntimeUI(launcher, launcherGroup);
    }

    private void createConfiguredRuntimeUI(IRuntimeLauncher launcher, Group launcherGroup) {
        Composite configuredRuntimeComposite = new Composite((Composite)launcherGroup, 0);
        configuredRuntimeComposite.setLayout((Layout)new RowLayout());
        configuredRuntimeComposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label configuredRuntimeTextLabel = new Label(configuredRuntimeComposite, 0);
        configuredRuntimeTextLabel.setText("Currently configured runtime: ");
        Link configuredRuntimePathLabel = new Link(configuredRuntimeComposite, 0);
        configuredRuntimePathLabel.setText("<a>" + launcher.getRuntimePath() + "</a>");
        configuredRuntimePathLabel.addListener(13, ev -> {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getSite().getWorkbenchWindow().getShell(), (String)launcher.getPathPreferenceSettingPageID(), (String[])new String[]{launcher.getPathPreferenceSettingPageID(), "org.eclipse.fordiac.ide.preferences.FordiacPreferencePage"}, null);
            dialog.open();
            configuredRuntimePathLabel.setText("<a>" + launcher.getRuntimePath() + "</a>");
            configuredRuntimeComposite.layout();
        });
    }

    private static IConfigurationElement[] getRuntimeLaunchers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.runtime", "RuntimeLauncher");
        Arrays.sort(elems, (element1, element2) -> {
            String order1 = element1.getAttribute("order");
            String order2 = element2.getAttribute("order");
            if (order1 == null) {
                return order2 == null ? 0 : 1;
            }
            if (order2 == null) {
                return -1;
            }
            return order1.compareTo(order2);
        });
        return elems;
    }

    private void createLaunchButton(IRuntimeLauncher launcher, Group launcherGroup) {
        Button launchButton = new Button((Composite)launcherGroup, 64);
        launchButton.setText("Launch " + launcher.getName());
        GridData launchButtonData = new GridData();
        launchButtonData.verticalSpan = launcher.getNumParameters();
        launchButtonData.verticalAlignment = 4;
        launchButtonData.horizontalAlignment = 4;
        launchButton.setLayoutData((Object)launchButtonData);
        launchButton.addListener(13, event -> {
            try {
                launcher.launch();
                this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
                for (LaunchParameter param : launcher.getParams()) {
                    if (Arrays.asList(this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).getItems()).contains(this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).getText())) continue;
                    this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).add(this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).getText(), 0);
                }
            }
            catch (LaunchRuntimeException e1) {
                Activator.getDefault().logError(e1.getMessage(), e1);
                this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(e1.getMessage());
            }
        });
    }

    public void setFocus() {
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    private void initFields() {
        if (this.memento == null) {
            return;
        }
        IMemento[] values = this.memento.getChildren(VALUES);
        for (IRuntimeLauncher launcher : this.launchers) {
            for (LaunchParameter param : launcher.getParams()) {
                if (!param.isFixedValues()) {
                    this.configureDynamicParam(values, launcher, param);
                }
                this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).select(0);
            }
        }
    }

    private void configureDynamicParam(IMemento[] values, IRuntimeLauncher launcher, LaunchParameter param) {
        IMemento[] iMementoArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento mem = iMementoArray[n2];
            String text = mem.getTextData();
            if (text != null && mem.getID().equals(RuntimeLauncherView.getLaunchParamID(launcher, param))) {
                String[] data;
                text = text.substring(1, text.length() - 1);
                String[] stringArray = data = text.split(",");
                int n3 = data.length;
                int n4 = 0;
                while (n4 < n3) {
                    String element = stringArray[n4];
                    String temp = element.trim();
                    if (!Arrays.asList(this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).getItems()).contains(temp)) {
                        this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).add(temp);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static String getLaunchParamID(IRuntimeLauncher launcher, LaunchParameter param) {
        return String.valueOf(launcher.getName()) + "." + param.getName();
    }

    public void saveState(IMemento memento) {
        for (IRuntimeLauncher launcher : this.launchers) {
            for (LaunchParameter param : launcher.getParams()) {
                if (param.isFixedValues()) continue;
                IMemento mem = memento.createChild(VALUES, RuntimeLauncherView.getLaunchParamID(launcher, param));
                mem.putTextData(Arrays.deepToString(this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).getItems()));
            }
        }
    }
}

