/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.gef.commands.Command;

public class ChangeNameCommand
extends Command {
    private INamedElement element;
    private String name;
    private String oldName;
    private FBNetworkElement fbNetworkElement;
    private AdapterDeclaration adapterDeclaration;

    public ChangeNameCommand(INamedElement element, String name) {
        this.element = element;
        this.name = name;
    }

    public boolean canExecute() {
        return NameRepository.isValidName((INamedElement)this.element, (String)this.name);
    }

    public void execute() {
        this.oldName = this.element.getName();
        if (this.element instanceof AdapterDeclaration && this.element.eContainer().eContainer() instanceof CompositeFBType) {
            this.fbNetworkElement = ((AdapterDeclaration)this.element).getAdapterFB();
        }
        if (this.element instanceof AdapterFB) {
            this.adapterDeclaration = ((AdapterFB)this.element).getAdapterDecl();
        }
        this.redo();
    }

    public void undo() {
        this.element.setName(this.oldName);
        if (this.fbNetworkElement != null) {
            this.fbNetworkElement.setName(this.oldName);
        }
        if (this.adapterDeclaration != null) {
            this.adapterDeclaration.setName(this.oldName);
        }
    }

    public void redo() {
        this.element.setName(this.name);
        if (this.fbNetworkElement != null) {
            this.fbNetworkElement.setName(this.name);
        }
        if (this.adapterDeclaration != null) {
            this.adapterDeclaration.setName(this.name);
        }
    }
}

