/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OtherAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.TextAlgorithm;
import org.eclipse.gef.commands.Command;

public abstract class AbstractChangeAlgorithmTypeCommand
extends Command {
    private final BaseFBType fbType;
    private final Algorithm oldAlgorithm;
    private Algorithm newAlgorithm;
    private final String algorithmType;

    public AbstractChangeAlgorithmTypeCommand(BaseFBType fbType, Algorithm oldAlgorithm, String algorithmType) {
        this.fbType = fbType;
        this.oldAlgorithm = oldAlgorithm;
        this.algorithmType = algorithmType;
    }

    public boolean canExecute() {
        if (this.algorithmType.equalsIgnoreCase("ST")) {
            if (this.oldAlgorithm instanceof STAlgorithm) {
                return false;
            }
            if (!(this.oldAlgorithm instanceof TextAlgorithm) && !(this.oldAlgorithm instanceof OtherAlgorithm)) {
                return false;
            }
        } else if (!(this.oldAlgorithm instanceof STAlgorithm) && (this.oldAlgorithm instanceof TextAlgorithm || this.oldAlgorithm instanceof OtherAlgorithm)) {
            return false;
        }
        return true;
    }

    public void execute() {
        this.newAlgorithm = this.algorithmType.equalsIgnoreCase("ST") ? this.createSTAlgorithm() : this.createOtherAlgorithm();
        this.changeAlgorithm(this.getOldAlgorithm(), this.getNewAlgorithm());
    }

    public void undo() {
        this.changeAlgorithm(this.getNewAlgorithm(), this.getOldAlgorithm());
    }

    public void redo() {
        this.changeAlgorithm(this.getOldAlgorithm(), this.getNewAlgorithm());
    }

    protected abstract void changeAlgorithm(Algorithm var1, Algorithm var2);

    public Algorithm getNewAlgorithm() {
        return this.newAlgorithm;
    }

    protected Algorithm getOldAlgorithm() {
        return this.oldAlgorithm;
    }

    protected BaseFBType getType() {
        return this.fbType;
    }

    private Algorithm createSTAlgorithm() {
        STAlgorithm algorithm = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
        algorithm.setText(((TextAlgorithm)this.oldAlgorithm).getText());
        algorithm.setName(this.oldAlgorithm.getName());
        algorithm.setComment(this.oldAlgorithm.getComment());
        return algorithm;
    }

    private Algorithm createOtherAlgorithm() {
        OtherAlgorithm algorithm = LibraryElementFactory.eINSTANCE.createOtherAlgorithm();
        algorithm.setText(((TextAlgorithm)this.oldAlgorithm).getText());
        algorithm.setName(this.oldAlgorithm.getName());
        algorithm.setComment(this.oldAlgorithm.getComment());
        algorithm.setLanguage("AnyText");
        return algorithm;
    }
}

