/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import java.util.Arrays;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateInternalVariableCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteInternalVariableCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.InternalVarsLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.ECCSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeArraySizeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInitialValueCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTypeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class InternalVarsSection
extends ECCSection {
    private static final String IV_NAME = "NAME";
    private static final String IV_TYPE = "TYPE";
    private static final String IV_ARRAY = "ARRAY_SIZE";
    private static final String IV_INIT = "INITIAL_VALUE";
    private static final String IV_COMMENT = "COMMENT";
    private TableViewer internalVarsViewer;
    private ComboBoxCellEditor typeDropDown;
    private String[] dataTypes = new String[DataTypeLibrary.getInstance().getDataTypesSorted().size()];

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createInternalVarsControls(parent);
    }

    public void createInternalVarsControls(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        AddDeleteWidget buttons = new AddDeleteWidget();
        buttons.createControls(composite, this.getWidgetFactory());
        this.internalVarsViewer = TableWidgetFactory.createTableViewer((Composite)composite);
        InternalVarsSection.configureTableLayout(this.internalVarsViewer.getTable());
        int i = 0;
        while (i < DataTypeLibrary.getInstance().getDataTypesSorted().size()) {
            this.dataTypes[i] = ((DataType)DataTypeLibrary.getInstance().getDataTypesSorted().toArray()[i]).getName();
            ++i;
        }
        this.internalVarsViewer.setCellEditors(this.createCellEditors(this.internalVarsViewer.getTable()));
        this.internalVarsViewer.setColumnProperties(new String[]{IV_NAME, IV_TYPE, IV_ARRAY, IV_INIT, IV_COMMENT});
        this.internalVarsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.internalVarsViewer.setLabelProvider((IBaseLabelProvider)new InternalVarsLabelProvider());
        this.internalVarsViewer.setCellModifier((ICellModifier)new InternalVarsCellModifier());
        buttons.bindToTableViewer(this.internalVarsViewer, (CommandExecutor)this, ref -> new CreateInternalVariableCommand(this.getType()), ref -> new DeleteInternalVariableCommand(this.getType(), (VarDeclaration)ref));
    }

    private static void configureTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText("Name");
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText("Type");
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText("Array Size");
        TableColumn column4 = new TableColumn(table, 16384);
        column4.setText("Initial Value");
        TableColumn column5 = new TableColumn(table, 16384);
        column5.setText("Comment");
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 30));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 30));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 50));
        table.setLayout((Layout)layout);
    }

    private CellEditor[] createCellEditors(Table table) {
        TextCellEditor varNameEditor = new TextCellEditor((Composite)table);
        ((Text)varNameEditor.getControl()).addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        this.typeDropDown = ComboBoxWidgetFactory.createComboBoxCellEditor((Composite)table, (String[])this.dataTypes, (int)8);
        return new CellEditor[]{varNameEditor, this.typeDropDown, new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
    }

    protected void setInputCode() {
        this.internalVarsViewer.setCellModifier(null);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.internalVarsViewer.setInput((Object)this.getType().getInternalVars());
        }
        this.commandStack = commandStackBuffer;
    }

    protected void setInputInit() {
    }

    private final class InternalVarsCellModifier
    implements ICellModifier {
        private InternalVarsCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            VarDeclaration var = (VarDeclaration)element;
            switch (property) {
                case "NAME": {
                    return var.getName();
                }
                case "TYPE": {
                    return Arrays.asList(InternalVarsSection.this.typeDropDown.getItems()).indexOf(var.getType().getName());
                }
                case "COMMENT": {
                    return var.getComment();
                }
                case "ARRAY_SIZE": {
                    return Integer.toString(var.getArraySize());
                }
            }
            return var.getValue().getValue();
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            VarDeclaration data = (VarDeclaration)tableItem.getData();
            ChangeInitialValueCommand cmd = null;
            switch (property) {
                case "NAME": {
                    cmd = new ChangeNameCommand((INamedElement)data, value.toString());
                    break;
                }
                case "TYPE": {
                    cmd = new ChangeTypeCommand(data, DataTypeLibrary.getInstance().getType(InternalVarsSection.this.dataTypes[(Integer)value]));
                    break;
                }
                case "COMMENT": {
                    cmd = new ChangeCommentCommand((INamedElement)data, value.toString());
                    break;
                }
                case "ARRAY_SIZE": {
                    cmd = new ChangeArraySizeCommand(data, value.toString());
                    break;
                }
                default: {
                    cmd = new ChangeInitialValueCommand(data, value.toString());
                }
            }
            InternalVarsSection.this.executeCommand((Command)cmd);
            InternalVarsSection.this.internalVarsViewer.refresh((Object)data);
        }
    }
}

