/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.monitoringbase;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.deployment.Activator;
import org.eclipse.fordiac.ide.deployment.monitoringbase.IMonitoringListener;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;

public abstract class AbstractMonitoringManager {
    private static AbstractMonitoringManager monitoringManager = null;
    private static final AbstractMonitoringManager dummyMonitoringManager = new AbstractMonitoringManager(){

        @Override
        public void enableSystem(AutomationSystem system) {
        }

        @Override
        public void enableSystemSynch(AutomationSystem system, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        }

        @Override
        public void disableSystem(AutomationSystem system) {
        }

        @Override
        public void disableSystemSynch(AutomationSystem system, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        }

        @Override
        public boolean isSystemMonitored(AutomationSystem system) {
            return false;
        }
    };
    private final List<IMonitoringListener> monitoringListeners = new ArrayList<IMonitoringListener>();
    private List<IMonitoringListener> watchesAdapter = new ArrayList<IMonitoringListener>();

    public static AbstractMonitoringManager getMonitoringManager() {
        if (monitoringManager == null) {
            monitoringManager = AbstractMonitoringManager.createMonitoringManager();
        }
        return monitoringManager;
    }

    private static AbstractMonitoringManager createMonitoringManager() {
        IConfigurationElement[] elems;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.deployment", "monitoringmanager");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof AbstractMonitoringManager) {
                    return (AbstractMonitoringManager)object;
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError("error in creating monitoring manager", (Exception)((Object)corex));
            }
            ++n2;
        }
        Activator.getDefault().logError("No monitoring manager provided");
        return dummyMonitoringManager;
    }

    public void registerMonitoringListener(IMonitoringListener listener) {
        if (!this.monitoringListeners.contains(listener)) {
            this.monitoringListeners.add(listener);
        }
    }

    public void notifyAddPort(PortElement port) {
        for (IMonitoringListener monitoringListener : this.monitoringListeners) {
            monitoringListener.notifyAddPort(port);
        }
    }

    public void notifyRemovePort(PortElement port) {
        for (IMonitoringListener monitoringListener : this.monitoringListeners) {
            monitoringListener.notifyRemovePort(port);
        }
    }

    public void notifyTriggerEvent(PortElement port) {
        for (IMonitoringListener monitoringListener : this.monitoringListeners) {
            monitoringListener.notifyTriggerEvent(port);
        }
    }

    public void addWatchesAdapter(IMonitoringListener adapter) {
        if (!this.watchesAdapter.contains(adapter)) {
            this.watchesAdapter.add(adapter);
        }
    }

    public void removeWatchesAdapter(IMonitoringListener adapter) {
        this.watchesAdapter.remove(adapter);
    }

    public void notifyWatchesAdapterPortAdded(PortElement port) {
        for (IMonitoringListener adapter : this.watchesAdapter) {
            adapter.notifyAddPort(port);
        }
    }

    public void notifyWatchesAdapterPortRemoved(PortElement port) {
        for (IMonitoringListener adapter : this.watchesAdapter) {
            adapter.notifyRemovePort(port);
        }
    }

    public abstract void disableSystem(AutomationSystem var1);

    public abstract void disableSystemSynch(AutomationSystem var1, IProgressMonitor var2) throws InvocationTargetException, InterruptedException;

    public abstract void enableSystem(AutomationSystem var1);

    public abstract void enableSystemSynch(AutomationSystem var1, IProgressMonitor var2) throws InvocationTargetException, InterruptedException;

    public abstract boolean isSystemMonitored(AutomationSystem var1);
}

