/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.internal.registration.FileProvider;
import org.eclipse.urischeme.internal.registration.IFileProvider;
import org.eclipse.urischeme.internal.registration.IProcessExecutor;
import org.eclipse.urischeme.internal.registration.PlistFileWriter;
import org.eclipse.urischeme.internal.registration.ProcessExecutor;
import org.eclipse.urischeme.internal.registration.SchemeInformation;

public class RegistrationMacOsX
implements IOperatingSystemRegistration {
    private static final String PLIST_PATH_SUFFIX = "/Contents/Info.plist";
    private static final String LSREGISTER = "/System/Library/Frameworks/CoreServices.framework/Versions/A/Frameworks/LaunchServices.framework/Versions/A/Support/lsregister";
    private static final String UNREGISTER = "-u";
    private static final String RECURSIVE = "-r";
    private static final String DUMP = "-dump";
    private IFileProvider fileProvider;
    private IProcessExecutor processExecutor;

    public RegistrationMacOsX() {
        this(new FileProvider(), new ProcessExecutor());
    }

    public RegistrationMacOsX(IFileProvider fileProvider, IProcessExecutor processExecutor) {
        this.fileProvider = fileProvider;
        this.processExecutor = processExecutor;
    }

    @Override
    public void handleSchemes(Collection<IScheme> toAdd, Collection<IScheme> toRemove) throws Exception {
        String pathToEclipseApp = this.getPathToEclipseApp();
        this.changePlistFile(toAdd, toRemove, pathToEclipseApp);
        this.registerAppWithLsregister(pathToEclipseApp);
    }

    @Override
    public List<ISchemeInformation> getSchemesInformation(Collection<IScheme> schemes) throws Exception {
        ArrayList<ISchemeInformation> returnList = new ArrayList<ISchemeInformation>();
        String lsRegisterOutput = this.processExecutor.execute(LSREGISTER, DUMP);
        String[] lsRegisterEntries = lsRegisterOutput.split("-{80}\n");
        for (IScheme scheme : schemes) {
            SchemeInformation schemeInfo = new SchemeInformation(scheme.getName(), scheme.getDescription());
            String location = this.determineHandlerLocation(lsRegisterEntries, scheme.getName());
            if (location != "" && this.getEclipseLauncher().startsWith(location)) {
                schemeInfo.setHandled(true);
            }
            schemeInfo.setHandlerLocation(location);
            returnList.add(schemeInfo);
        }
        return returnList;
    }

    private String determineHandlerLocation(String[] lsRegisterEntries, String scheme) throws Exception {
        List splitList = ((Stream)Stream.of(lsRegisterEntries).parallel()).filter(s -> s.startsWith("BundleClass")).filter(s -> s.contains(String.valueOf(scheme) + ":")).collect(Collectors.toList());
        String lines = "(?:.*\\n)*";
        Pattern pattern = Pattern.compile("^" + lines + "\\spath:\\s*(.*)\\n" + lines + "\\s*bindings:.*" + scheme + ":", 8);
        for (String entry : splitList) {
            Matcher matcher = pattern.matcher(entry);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return "";
    }

    private PlistFileWriter getPlistFileWriter(String plistPath) throws IOException {
        return new PlistFileWriter(this.fileProvider.newReader(plistPath));
    }

    @Override
    public String getEclipseLauncher() {
        return this.getPathToEclipseApp();
    }

    private void registerAppWithLsregister(String pathToEclipseApp) throws Exception {
        this.processExecutor.execute(LSREGISTER, UNREGISTER, pathToEclipseApp);
        this.processExecutor.execute(LSREGISTER, RECURSIVE, pathToEclipseApp);
    }

    private void changePlistFile(Collection<IScheme> toAdd, Collection<IScheme> toRemove, String pathToEclipseApp) throws IOException {
        String plistPath = String.valueOf(pathToEclipseApp) + PLIST_PATH_SUFFIX;
        PlistFileWriter writer = this.getPlistFileWriter(plistPath);
        for (IScheme scheme : toAdd) {
            writer.addScheme(scheme.getName(), scheme.getDescription());
        }
        for (IScheme scheme : toRemove) {
            writer.removeScheme(scheme.getName());
        }
        writer.writeTo(this.fileProvider.newWriter(plistPath));
    }

    private String getPathToEclipseApp() {
        String homeLocationProperty = System.getProperty("eclipse.home.location");
        return homeLocationProperty.replaceAll("file:(.*.app).*", "$1");
    }

    @Override
    public boolean canOverwriteOtherApplicationsRegistration() {
        return false;
    }
}

