/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;

public final class FBNetworkHelper {
    public static FBNetwork copyFBNetWork(FBNetwork srcNetwork, InterfaceList destInterface) {
        FBNetwork dstNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        dstNetwork.getNetworkElements().addAll(EcoreUtil.copyAll(srcNetwork.getNetworkElements()));
        FBNetworkHelper.createConnections(srcNetwork, dstNetwork, destInterface);
        return dstNetwork;
    }

    private static void createConnections(FBNetwork srcNetwork, FBNetwork dstNetwork, InterfaceList destInterface) {
        for (Connection connection : srcNetwork.getEventConnections()) {
            dstNetwork.getEventConnections().add((Object)((EventConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
        for (Connection connection : srcNetwork.getDataConnections()) {
            dstNetwork.getDataConnections().add((Object)((DataConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
        for (Connection connection : srcNetwork.getAdapterConnections()) {
            dstNetwork.getAdapterConnections().add((Object)((AdapterConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
    }

    private static Connection createConnection(FBNetwork srcNetwork, InterfaceList destInterface, FBNetwork dstNetwork, Connection connection) {
        Connection newConn = (Connection)EcoreUtil.copy((EObject)connection);
        newConn.setSource(FBNetworkHelper.getInterfaceElement(connection.getSource(), destInterface, dstNetwork, srcNetwork));
        newConn.setDestination(FBNetworkHelper.getInterfaceElement(connection.getDestination(), destInterface, dstNetwork, srcNetwork));
        return newConn;
    }

    private static IInterfaceElement getInterfaceElement(IInterfaceElement ie, InterfaceList typeInterface, FBNetwork dstNetwork, FBNetwork srcNetwork) {
        if (ie.getFBNetworkElement() == null) {
            return typeInterface.getInterfaceElement(ie.getName());
        }
        if (!srcNetwork.equals(ie.getFBNetworkElement().getFbNetwork())) {
            return typeInterface.getInterfaceElement(ie.getName());
        }
        FBNetworkElement element = dstNetwork.getElementNamed(ie.getFBNetworkElement().getName());
        if (element == null) {
            return null;
        }
        return element.getInterfaceElement(ie.getName());
    }

    private FBNetworkHelper() {
        throw new IllegalStateException("FBNetworkHelper is a utility class that can not be instantiated");
    }
}

