/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.commands;

import java.text.MessageFormat;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.gef.commands.Command;

public class AdjustConnectionCommand
extends Command {
    private final Connection connection;
    private final Point point;
    private final int index;
    private final org.eclipse.fordiac.ide.model.libraryElement.Connection modelConnection;
    private final double zoom;

    public AdjustConnectionCommand(Connection connection, Point p, int index, org.eclipse.fordiac.ide.model.libraryElement.Connection modelConnection, double zoom) {
        this.connection = connection;
        this.point = p;
        this.index = index;
        this.modelConnection = modelConnection;
        this.zoom = zoom;
    }

    public void execute() {
        Point sourceP = this.getSourcePoint();
        Point destP = this.getDestinationPoint();
        int scaledMinDistance = (int)Math.floor(12.0 * this.zoom);
        switch (this.index) {
            case 1: {
                int newDx1 = Math.max(this.point.x - sourceP.x, scaledMinDistance);
                if (this.modelConnection.getDx2() == 0) {
                    newDx1 = Math.min(newDx1, destP.x - sourceP.x - scaledMinDistance);
                }
                this.modelConnection.setDx1((int)Math.floor((double)newDx1 / this.zoom));
                break;
            }
            case 2: {
                this.modelConnection.setDy((int)Math.floor((double)(this.point.y - sourceP.y) / this.zoom));
                break;
            }
            case 3: {
                int newDx2 = Math.max(destP.x - this.point.x, scaledMinDistance);
                this.modelConnection.setDx2((int)Math.floor((double)newDx2 / this.zoom));
                break;
            }
            default: {
                Activator.getDefault().logError(MessageFormat.format("Wrong connection segment index ({0}) provided to AdjustConnectionCommand!", this.index));
            }
        }
        this.connection.revalidate();
    }

    private Point getDestinationPoint() {
        Point destP = this.connection.getTargetAnchor().getLocation(this.connection.getTargetAnchor().getReferencePoint()).getCopy();
        return destP;
    }

    private Point getSourcePoint() {
        Point sourceP = this.connection.getSourceAnchor().getLocation(this.connection.getSourceAnchor().getReferencePoint()).getCopy();
        return sourceP;
    }

    public void undo() {
    }

    public void redo() {
    }
}

