/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.router;

import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.figures.HideableConnection;
import org.eclipse.fordiac.ide.gef.policies.AdjustConnectionEditPolicy;
import org.eclipse.fordiac.ide.gef.router.BendpointPolicyRouter;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.gef.EditPolicy;

public class MoveableRouter
extends BendpointConnectionRouter
implements BendpointPolicyRouter {
    public static final int MIN_CONNECTION_FB_DISTANCE = 12;
    private static final PrecisionPoint START_POINT = new PrecisionPoint();
    private static final PrecisionPoint END_POINT = new PrecisionPoint();

    public void route(Connection conn) {
        PointList points = conn.getPoints();
        points.removeAllPoints();
        if (MoveableRouter.needsSwap(conn)) {
            END_POINT.setLocation(conn.getSourceAnchor().getLocation(conn.getSourceAnchor().getReferencePoint()));
            START_POINT.setLocation(conn.getTargetAnchor().getLocation(conn.getTargetAnchor().getReferencePoint()));
        } else {
            START_POINT.setLocation(conn.getSourceAnchor().getLocation(conn.getSourceAnchor().getReferencePoint()));
            END_POINT.setLocation(conn.getTargetAnchor().getLocation(conn.getTargetAnchor().getReferencePoint()));
        }
        conn.translateToRelative((Translatable)START_POINT);
        conn.translateToRelative((Translatable)END_POINT);
        points.addPoint((Point)START_POINT);
        if (conn instanceof HideableConnection) {
            MoveableRouter.setHideableConnectionBendPoints((HideableConnection)conn, (Point)START_POINT, (Point)END_POINT, points);
        } else {
            MoveableRouter.setCreationBendPoints((Point)START_POINT, (Point)END_POINT, points);
        }
        points.addPoint((Point)END_POINT);
        conn.setPoints(points);
    }

    private static void setHideableConnectionBendPoints(HideableConnection conn, Point sourceP, Point destP, PointList points) {
        if (conn.getModel() != null) {
            MoveableRouter.valdidateConnectionRoutingParams(conn.getModel(), sourceP, destP);
            MoveableRouter.createBendPointList(sourceP, destP, conn.getModel(), points);
        }
    }

    private static void valdidateConnectionRoutingParams(org.eclipse.fordiac.ide.model.libraryElement.Connection conn, Point sourceP, Point destP) {
        if (conn.getDx1() == 0) {
            if (sourceP.y != destP.y || MoveableRouter.requires5SegementConnection(sourceP, destP)) {
                if (MoveableRouter.requires5SegementConnection(sourceP, destP)) {
                    MoveableRouter.generateInitial5SegmentParams(conn, sourceP, destP);
                } else {
                    MoveableRouter.generateInitial3SegmentParams(conn, sourceP, destP);
                }
            }
        } else if (sourceP.y == destP.y && !MoveableRouter.requires5SegementConnection(sourceP, destP)) {
            conn.setDx1(0);
        } else if (conn.getDx2() == 0) {
            if (MoveableRouter.requires5SegementConnection(sourceP, destP)) {
                MoveableRouter.generateInitial5SegmentParams(conn, sourceP, destP);
            } else if (sourceP.x + conn.getDx1() > destP.x - 12) {
                conn.setDx1(destP.x - sourceP.x - 12);
            }
        } else if (!MoveableRouter.requires5SegementConnection(sourceP, destP)) {
            conn.setDx2(0);
            conn.setDy(0);
            MoveableRouter.generateInitial3SegmentParams(conn, sourceP, destP);
        }
    }

    private static void generateInitial3SegmentParams(org.eclipse.fordiac.ide.model.libraryElement.Connection conn, Point sourceP, Point destP) {
        conn.setDx1((destP.x - sourceP.x) / 2);
    }

    private static void generateInitial5SegmentParams(org.eclipse.fordiac.ide.model.libraryElement.Connection conn, Point sourceP, Point destP) {
        conn.setDx1(12);
        conn.setDx2(12);
        conn.setDy((destP.y - sourceP.y) / 2);
        if (conn.getDy() == 0) {
            conn.setDy(24);
        }
    }

    private static boolean requires5SegementConnection(Point sourceP, Point destP) {
        return sourceP.x >= destP.x - 24;
    }

    private static void createBendPointList(Point sourceP, Point destP, org.eclipse.fordiac.ide.model.libraryElement.Connection modelConn, PointList points) {
        if (modelConn.getDx1() != 0) {
            points.addPoint(new Point(sourceP.x + modelConn.getDx1(), sourceP.y));
            if (modelConn.getDx2() == 0) {
                points.addPoint(new Point(sourceP.x + modelConn.getDx1(), destP.y));
            } else {
                points.addPoint(new Point(sourceP.x + modelConn.getDx1(), sourceP.y + modelConn.getDy()));
                points.addPoint(new Point(destP.x - modelConn.getDx2(), sourceP.y + modelConn.getDy()));
                points.addPoint(new Point(destP.x - modelConn.getDx2(), destP.y));
            }
        }
    }

    private static void setCreationBendPoints(Point sourceP, Point destP, PointList points) {
        EventConnection modelConn = LibraryElementFactory.eINSTANCE.createEventConnection();
        MoveableRouter.valdidateConnectionRoutingParams((org.eclipse.fordiac.ide.model.libraryElement.Connection)modelConn, sourceP, destP);
        MoveableRouter.createBendPointList(sourceP, destP, (org.eclipse.fordiac.ide.model.libraryElement.Connection)modelConn, points);
    }

    private static boolean needsSwap(Connection conn) {
        if (conn.getSourceAnchor() instanceof FixedAnchor && ((FixedAnchor)conn.getSourceAnchor()).getEditPart() instanceof InterfaceEditPart) {
            InterfaceEditPart ep = (InterfaceEditPart)((FixedAnchor)conn.getSourceAnchor()).getEditPart();
            return ep.isInput();
        }
        return false;
    }

    @Override
    public EditPolicy getBendpointPolicy(Object modelObject) {
        if (modelObject instanceof org.eclipse.fordiac.ide.model.libraryElement.Connection) {
            return new AdjustConnectionEditPolicy((org.eclipse.fordiac.ide.model.libraryElement.Connection)modelObject);
        }
        return null;
    }
}

