/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import org.eclipse.fordiac.ide.model.IdentifierVerifyer;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewSystemPage
extends WizardNewProjectCreationPage {
    private static final String APPLICATION_NAME_PREFIX = "App";
    private boolean importDefaultPalette = true;
    private boolean openApplication = true;
    private Button advancedButton;
    private Text applicationName;
    private int linkedResourceGroupHeight = -1;
    private Composite advancedGroupContainer;
    private Composite advancedGroupParent;
    private boolean appNameManuallyChanged = false;
    private boolean blockListeners = false;
    private Listener applicationNameModifyListener = e -> {
        if (!this.blockListeners) {
            this.appNameManuallyChanged = true;
            boolean valid = this.validatePage();
            this.setPageComplete(valid);
        }
    };

    public NewSystemPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createApplicationNameGroup((Composite)this.getControl());
        this.createAdvancedControls((Composite)this.getControl());
        Composite composite = (Composite)this.getControl();
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void createApplicationNameGroup(Composite parent) {
        Composite applicationNameGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        applicationNameGroup.setLayout((Layout)layout);
        applicationNameGroup.setLayoutData((Object)new GridData(768));
        Label applicationLabel = new Label(applicationNameGroup, 0);
        applicationLabel.setText(Messages.NewSystemWizard_InitialApplicationName);
        applicationLabel.setFont(parent.getFont());
        this.applicationName = new Text(applicationNameGroup, 2048);
        GridData data = new GridData(768);
        this.applicationName.setLayoutData((Object)data);
        this.applicationName.setFont(parent.getFont());
        this.applicationName.addListener(24, this.applicationNameModifyListener);
    }

    protected boolean validatePage() {
        if (!IdentifierVerifyer.isValidIdentifier((String)this.getProjectName())) {
            this.setErrorMessage(Messages.SystemNameNotValid);
            return false;
        }
        if (!SystemManager.isUniqueSystemName((String)this.getProjectName())) {
            this.setErrorMessage(Messages.SystemNameAlreadyUsed);
            return false;
        }
        if (!this.appNameManuallyChanged) {
            this.blockListeners = true;
            this.applicationName.setText(String.valueOf(this.getProjectName()) + APPLICATION_NAME_PREFIX);
            this.blockListeners = false;
        }
        if (!IdentifierVerifyer.isValidIdentifier((String)this.getInitialApplicationName())) {
            return false;
        }
        return super.validatePage();
    }

    public String getInitialApplicationName() {
        return this.applicationName.getText();
    }

    public boolean getOpenApplication() {
        return this.openApplication;
    }

    private void createAdvancedControls(Composite parent) {
        this.advancedGroupParent = new Composite(parent, 0);
        this.advancedGroupParent.setFont(parent.getFont());
        this.advancedGroupParent.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.advancedGroupParent.setLayout((Layout)layout);
        this.advancedButton = new Button(this.advancedGroupParent, 8);
        this.advancedButton.setFont(this.advancedGroupParent.getFont());
        this.advancedButton.setText(Messages.NewSystemWizard_ShowAdvanced);
        GridData data = this.setButtonLayoutData(this.advancedButton);
        data.horizontalAlignment = 1;
        this.advancedButton.setLayoutData((Object)data);
        this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSystemPage.this.handleAdvancedButtonSelect();
            }
        });
    }

    protected void handleAdvancedButtonSelect() {
        if (this.advancedGroupContainer != null) {
            this.advancedGroupContainer.dispose();
            this.advancedGroupContainer = null;
            this.advancedButton.setText(Messages.NewSystemWizard_ShowAdvanced);
        } else {
            this.createAdvancedGroup();
            if (this.linkedResourceGroupHeight == -1) {
                Point groupSize = this.advancedGroupContainer.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = groupSize.y;
            }
            this.advancedButton.setText(Messages.NewSystemWizard_HideAdvanced);
        }
        Composite compo = (Composite)this.getControl();
        compo.layout();
    }

    private void createAdvancedGroup() {
        this.advancedGroupContainer = new Composite(this.advancedGroupParent, 0);
        this.advancedGroupContainer.setLayout((Layout)new GridLayout());
        this.advancedGroupContainer.setLayoutData((Object)new GridData(768));
        Button importDefaultPaletteSB = new Button(this.advancedGroupContainer, 32);
        importDefaultPaletteSB.setSelection(this.importDefaultPalette);
        importDefaultPaletteSB.setText(Messages.PaletteManagementPage_LABEL_DefaultTypeLibrary);
        importDefaultPaletteSB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewSystemPage.this.importDefaultPalette = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewSystemPage.this.importDefaultPalette = false;
            }
        });
        Button openApplicationCheckbox = new Button(this.advancedGroupContainer, 32);
        openApplicationCheckbox.setText(Messages.NewApplicationPage_OpenApplicationForEditing);
        openApplicationCheckbox.setSelection(this.openApplication);
        openApplicationCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewSystemPage.this.openApplication = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewSystemPage.this.openApplication = false;
            }
        });
    }

    public boolean importDefaultPalette() {
        return this.importDefaultPalette;
    }
}

