/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import java.util.List;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.CommentTypeField;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

class CommentTypeEditPart
extends AbstractGraphicalEditPart
implements EditPart {
    private static final int WITH_SIZE = 10;
    private static final int DISTANCE_TO_FB_BORDER = 15;
    InterfaceEditPart referencedInterface;

    CommentTypeEditPart() {
    }

    public void activate() {
        super.activate();
        Object part = this.getViewer().getEditPartRegistry().get(this.getInterfaceElement());
        if (part instanceof InterfaceEditPart) {
            this.referencedInterface = (InterfaceEditPart)((Object)part);
            this.referencedInterface.getFigure().addAncestorListener(new AncestorListener(){

                public void ancestorRemoved(IFigure ancestor) {
                }

                public void ancestorMoved(IFigure ancestor) {
                    CommentTypeEditPart.this.refreshVisuals();
                }

                public void ancestorAdded(IFigure ancestor) {
                    CommentTypeEditPart.this.refreshVisuals();
                }
            });
        }
    }

    public void refresh() {
        super.refresh();
        this.refreshPosition();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshPosition();
    }

    private void refreshPosition() {
        if (this.getParent() != null && this.getInterfaceElement().eContainer() != null) {
            Rectangle bounds = null;
            Point p = this.calculatePos();
            bounds = new Rectangle(p.x, p.y, this.getFigureWidth(), -1);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
        }
    }

    private Point calculatePos() {
        if (this.referencedInterface != null) {
            Rectangle bounds = this.referencedInterface.getFigure().getBounds();
            InterfaceList interfaceList = (InterfaceList)this.getInterfaceElement().eContainer();
            int dx = 0;
            if (this.getInterfaceElement().isIsInput()) {
                int nrOfInputEvents = interfaceList.getEventInputs().size();
                dx = -15 - this.getFigureWidth() - nrOfInputEvents * 10;
            } else {
                int nrOfOutputEvents = interfaceList.getEventOutputs().size();
                dx = 15 + bounds.width + nrOfOutputEvents * 10;
            }
            return new Point(bounds.x + dx, bounds.y);
        }
        return new Point(0, 0);
    }

    private int getFigureWidth() {
        return this.getFigure().getPreferredSize().width;
    }

    public CommentTypeField getModel() {
        return (CommentTypeField)super.getModel();
    }

    private IInterfaceElement getInterfaceElement() {
        return this.getModel().getReferencedElement();
    }

    protected IFigure createFigure() {
        return new CommentTypeContainerFigure();
    }

    protected void createEditPolicies() {
    }

    protected List getModelChildren() {
        return this.getModel().getChildren();
    }

    private static class CommentTypeContainerFigure
    extends Figure {
        public CommentTypeContainerFigure() {
            GridLayout layout = new GridLayout(3, false);
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.setLayoutManager((LayoutManager)layout);
        }
    }
}

