/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.export.Activator;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.ExportFilter;
import org.eclipse.fordiac.ide.export.IExportTemplate;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;

public abstract class TemplateExportFilter
extends ExportFilter {
    @Override
    public final void export(IFile typeFile, String destination, boolean forceOverwrite) throws ExportException {
        this.export(typeFile, destination, forceOverwrite, null);
    }

    @Override
    public void export(IFile typeFile, String destination, boolean forceOverwrite, LibraryElement type) throws ExportException {
        try {
            Path destinationPath = Paths.get(destination, new String[0]);
            Set<? extends IExportTemplate> templates = this.getTemplates(type);
            for (IExportTemplate iExportTemplate : templates) {
                try {
                    CharSequence content = iExportTemplate.generate();
                    byte[] data = content.toString().getBytes();
                    this.getErrors().addAll(iExportTemplate.getErrors());
                    this.getWarnings().addAll(iExportTemplate.getWarnings());
                    this.getInfos().addAll(iExportTemplate.getInfos());
                    Path templatePath = destinationPath.resolve(iExportTemplate.getPath());
                    Files.write(templatePath, data, new OpenOption[0]);
                }
                catch (Exception t) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.fordiac.ide.export", 1, "Error during template generation", (Throwable)t));
                    this.getErrors().add(t.getMessage() != null ? t.getMessage() : "Error during template generation");
                }
            }
        }
        catch (Exception t) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.fordiac.ide.export", 1, "Error during template generation", (Throwable)t));
            this.getErrors().add(t.getMessage() != null ? t.getMessage() : "Error during template generation");
        }
    }

    protected abstract Set<? extends IExportTemplate> getTemplates(LibraryElement var1);
}

