/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.ECCEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.StateCreationFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateECStateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.ui.IWorkbenchPart;

public class NewStateAction
extends WorkbenchPartAction {
    public static final String CREATE_STATE = "org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions.CreateStateAction";
    private static StateCreationFactory stateFactory = new StateCreationFactory();
    private FigureCanvas viewerControl;
    private org.eclipse.swt.graphics.Point pos = new org.eclipse.swt.graphics.Point(0, 0);
    private ZoomManager zoomManager;

    public NewStateAction(IWorkbenchPart part) {
        super(part);
        this.setId(CREATE_STATE);
        this.setText(Messages.ECCActions_AddState);
        this.setImageDescriptor(FordiacImage.ICON_ADD_STATE.getImageDescriptor());
    }

    public void setViewerControl(FigureCanvas control) {
        this.viewerControl = control;
        if (this.viewerControl != null) {
            this.viewerControl.addMenuDetectListener(e -> {
                org.eclipse.swt.graphics.Point point = this.pos = this.viewerControl.toControl(e.x, e.y);
            });
        }
    }

    public void setZoomManager(ZoomManager zoomManager) {
        this.zoomManager = zoomManager;
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        ECCEditor editor = (ECCEditor)this.getWorkbenchPart();
        Point location = this.viewerControl.getViewport().getViewLocation();
        Point realPos = new Point(this.pos.x + location.x, this.pos.y + location.y);
        realPos.scale(1.0 / this.zoomManager.getZoom());
        ECState model = (ECState)stateFactory.getNewObject();
        this.execute(new CreateECStateCommand(model, realPos, editor.getFbType().getECC()));
        editor.outlineSelectionChanged(model);
    }
}

