/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SysConfTemplateTransferDropTargetListener;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfPaletteFactory;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationContextMenueProvider;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationEditorInput;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.SystemConfEditPartFactory;
import org.eclipse.fordiac.ide.systemmanagement.ISystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.ui.IEditorInput;

public class SystemConfigurationEditor
extends DiagramEditorWithFlyoutPalette
implements ISystemEditor {
    private SystemConfiguration sysConf;

    protected EditPartFactory getEditPartFactory() {
        return new SystemConfEditPartFactory((GraphicalEditor)this, this.getZoomManger());
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new SystemConfigurationContextMenueProvider((EditPartViewer)viewer, zoomManager, this.getActionRegistry());
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return new SysConfTemplateTransferDropTargetListener((EditPartViewer)this.getViewer(), this.getSystem());
    }

    public SystemConfiguration getModel() {
        return this.sysConf;
    }

    protected void setModel(IEditorInput input) {
        if (input instanceof SystemConfigurationEditorInput) {
            SystemConfigurationEditorInput sysConfInput = (SystemConfigurationEditorInput)input;
            this.sysConf = sysConfInput.getContent();
        }
        super.setModel(input);
    }

    public AutomationSystem getSystem() {
        return (AutomationSystem)this.sysConf.eContainer();
    }

    public void doSave(IProgressMonitor monitor) {
        SystemManager.INSTANCE.saveSystem(this.getSystem());
        this.getCommandStack().markSaveLocation();
        this.firePropertyChange(257);
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return SystemConfPaletteFactory.PALETTE_PREFERENCES;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.getModel() != null && this.getSystem() != null) {
            return SystemConfPaletteFactory.createPalette(this.getSystem());
        }
        return new PaletteRoot();
    }

    public void selectElement(TypedConfigureableObject refElement) {
        Object obj = this.getViewer().getEditPartRegistry().get(refElement);
        if (obj instanceof EditPart) {
            this.getViewer().select((EditPart)obj);
            this.getViewer().reveal((EditPart)obj);
        }
    }

    public void doSaveAs() {
    }
}

