/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.util.ArrayList;
import org.eclipse.core.commands.IHandler;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.MarqueeDragTracker;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.IHandlerService;

public class ZoomScalableFreeformRootEditPart
extends ScalableFreeformRootEditPart {
    public static final String TOP_LAYER = "TOPLAYER";

    public ZoomScalableFreeformRootEditPart(IWorkbenchPartSite site, ActionRegistry actionRegistry) {
        this.configureZoomManger();
        this.setupZoomActions(site, actionRegistry);
    }

    public DragTracker getDragTracker(Request req) {
        return new AdvancedMarqueeDragTracker();
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Primary Layer");
        ConnectionLayer connectionLayer = new ConnectionLayer();
        layeredPane.add((IFigure)connectionLayer, (Object)"Connection Layer");
        FreeformLayer topLayer = new FreeformLayer();
        topLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        layeredPane.add((IFigure)topLayer, (Object)TOP_LAYER);
        return layeredPane;
    }

    protected GridLayer createGridLayer() {
        return new MajorMinorGridLayer();
    }

    private void configureZoomManger() {
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        this.getZoomManager().setZoomLevelContributions(zoomLevels);
        this.getZoomManager().setZoomLevels(new double[]{0.25, 0.5, 0.75, 0.8, 0.85, 0.9, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0});
        this.getZoomManager().setZoomAnimationStyle(1);
    }

    private void setupZoomActions(IWorkbenchPartSite site, ActionRegistry actionRegistry) {
        ZoomInAction zoomIn = new ZoomInAction(this.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(this.getZoomManager());
        actionRegistry.registerAction((IAction)zoomIn);
        actionRegistry.registerAction((IAction)zoomOut);
        IHandlerService zoomInService = (IHandlerService)site.getService(IHandlerService.class);
        zoomInService.activateHandler(zoomIn.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomIn));
        IHandlerService zoomOutService = (IHandlerService)site.getService(IHandlerService.class);
        zoomOutService.activateHandler(zoomOut.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomOut));
    }

    public class AdvancedMarqueeDragTracker
    extends MarqueeDragTracker {
        protected boolean handleButtonDown(int button) {
            if (3 == button) {
                ZoomScalableFreeformRootEditPart.this.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            }
            return super.handleButtonDown(button);
        }
    }

    private static class MajorMinorGridLayer
    extends GridLayer {
        private static final int MAJOR_INTERLEAVE = 10;
        private static final int MEDIUM_INTERLEAVE = 5;
        private static final float[] GRID_MINOR_DASHES_STYLE = new float[]{1.0f, 5.0f};
        private static final float[] GRID_MEDIUM_DASHES_STYLE = new float[]{2.0f, 4.0f};
        private static final float[] GRID_MAJOR_DASHES_STYLE = new float[]{4.0f, 2.0f};

        private MajorMinorGridLayer() {
        }

        protected void paintGrid(Graphics g) {
            int origLineStyle = g.getLineStyle();
            g.setLineStyle(6);
            Rectangle clip = g.getClip(Rectangle.SINGLETON);
            if (this.gridX > 0) {
                this.drawVerLines(g, clip);
            }
            if (this.gridY > 0) {
                this.drawHorLines(g, clip);
            }
            g.setLineStyle(origLineStyle);
        }

        private void drawVerLines(Graphics g, Rectangle clip) {
            int majorInterleaveX = this.gridX * 10;
            int medInterleaveX = this.gridX * 5;
            int i = MajorMinorGridLayer.getLineStart(this.origin.x, clip.x, this.gridX);
            while (i < clip.x + clip.width) {
                MajorMinorGridLayer.setLineStyle(g, i, this.origin.x, majorInterleaveX, medInterleaveX);
                g.drawLine(i, clip.y, i, clip.y + clip.height);
                i += this.gridX;
            }
        }

        private void drawHorLines(Graphics g, Rectangle clip) {
            int majorInterleaveY = this.gridY * 10;
            int medInterleaveY = this.gridY * 5;
            int i = MajorMinorGridLayer.getLineStart(this.origin.y, clip.y, this.gridY);
            while (i < clip.y + clip.height) {
                MajorMinorGridLayer.setLineStyle(g, i, this.origin.y, majorInterleaveY, medInterleaveY);
                g.drawLine(clip.x, i, clip.x + clip.width, i);
                i += this.gridY;
            }
        }

        /*
         * Unable to fully structure code
         */
        private static int getLineStart(int origin, int clip, int distance) {
            block2: {
                newOrigin = origin;
                if (origin < clip) ** GOTO lbl8
                while (newOrigin - distance >= clip) {
                    newOrigin -= distance;
                }
                break block2;
lbl-1000:
                // 1 sources

                {
                    newOrigin += distance;
lbl8:
                    // 2 sources

                    ** while (newOrigin < clip)
                }
            }
            return newOrigin;
        }

        private static void setLineStyle(Graphics g, int currLinePos, int origin, int majorInterleave, int mediumInterleave) {
            int delta = origin - currLinePos;
            if (delta % majorInterleave == 0) {
                g.setLineDash(GRID_MAJOR_DASHES_STYLE);
            } else if (delta % mediumInterleave == 0) {
                g.setLineDash(GRID_MEDIUM_DASHES_STYLE);
            } else {
                g.setLineDash(GRID_MINOR_DASHES_STYLE);
            }
        }
    }
}

