/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class GradientLabel
extends Label {
    private final ZoomManager zoomManger;

    public GradientLabel(ZoomManager zoomManger) {
        this.zoomManger = zoomManger;
    }

    protected void paintFigure(Graphics graphics) {
        Display display = Display.getCurrent();
        Rectangle boundingRect = this.getBounds().getCopy();
        boundingRect.scale(this.zoomManger.getZoom());
        Point topLeft = boundingRect.getTopLeft();
        Point bottomRight = boundingRect.getBottomRight();
        Color first = FigureUtilities.lighter((Color)this.getBackgroundColor());
        Pattern pattern = new Pattern((Device)display, (float)topLeft.x, (float)topLeft.y, (float)bottomRight.x, (float)bottomRight.y, first, this.getBackgroundColor());
        graphics.setBackgroundPattern(pattern);
        graphics.fillRectangle(this.getBounds());
        graphics.setBackgroundPattern(null);
        pattern.dispose();
        first.dispose();
        graphics.translate(this.bounds.x, this.bounds.y);
        graphics.drawText(this.getSubStringText(), this.getTextLocation());
        graphics.translate(-this.bounds.x, -this.bounds.y);
    }
}

