/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.List;
import org.eclipse.fordiac.ide.application.commands.AddElementsToSubAppCommand;
import org.eclipse.fordiac.ide.application.commands.CommandUtil;
import org.eclipse.fordiac.ide.application.editors.SubAppNetworkEditor;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.ui.IEditorInput;

public class NewSubAppCommand
extends AbstractCreateFBNetworkElementCommand {
    private IEditorInput input = null;
    private final AddElementsToSubAppCommand addElements;
    private MapToCommand mappSubappCmd = null;

    public NewSubAppCommand(FBNetwork fbNetwork, List<?> selection, int x, int y) {
        super(fbNetwork, (FBNetworkElement)LibraryElementFactory.eINSTANCE.createSubApp(), x, y);
        this.getSubApp().setSubAppNetwork(LibraryElementFactory.eINSTANCE.createFBNetwork());
        this.addElements = new AddElementsToSubAppCommand(this.getSubApp(), selection);
        this.checkMapping(selection);
    }

    public void execute() {
        super.execute();
        this.addElements.execute();
        if (this.mappSubappCmd != null) {
            this.mappSubappCmd.execute();
        }
        this.openClosedEditor();
    }

    public void redo() {
        super.redo();
        this.addElements.redo();
        if (this.mappSubappCmd != null) {
            this.mappSubappCmd.redo();
        }
        this.openClosedEditor();
    }

    public void undo() {
        if (this.mappSubappCmd != null) {
            this.mappSubappCmd.undo();
        }
        this.addElements.undo();
        super.undo();
        this.closeOpenedSubApp();
    }

    private void checkMapping(List<?> selection) {
        Resource res = null;
        for (Object ne : selection) {
            if (!(ne instanceof EditPart) || !(((EditPart)ne).getModel() instanceof FBNetworkElement)) continue;
            FBNetworkElement element = (FBNetworkElement)((EditPart)ne).getModel();
            if (element.isMapped()) {
                if (res == null) {
                    res = element.getResource();
                    continue;
                }
                if (res == element.getResource()) continue;
                return;
            }
            return;
        }
        if (res != null) {
            this.mappSubappCmd = new MapToCommand((FBNetworkElement)this.getSubApp(), res);
        }
    }

    protected final InterfaceList getTypeInterfaceList() {
        return LibraryElementFactory.eINSTANCE.createInterfaceList();
    }

    protected String getInitalInstanceName() {
        return "SubApp";
    }

    private void closeOpenedSubApp() {
        this.input = CommandUtil.closeOpenedSubApp(this.getSubApp().getSubAppNetwork());
    }

    private SubApp getSubApp() {
        return (SubApp)this.getElement();
    }

    private void openClosedEditor() {
        if (this.input != null) {
            EditorUtils.openEditor((IEditorInput)this.input, (String)SubAppNetworkEditor.class.getName());
        }
    }
}

