/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.gef.commands.Command;

public class ChangeServiceInterfaceNameCommand
extends Command {
    private FBType fb;
    private boolean isLeftInterface;
    private String name;
    private String oldName;

    public ChangeServiceInterfaceNameCommand(String name, FBType fb, boolean isLeftInterface) {
        this.fb = fb;
        this.isLeftInterface = isLeftInterface;
        this.name = name;
    }

    public void execute() {
        if (this.fb.getService() == null) {
            this.fb.setService(LibraryElementFactory.eINSTANCE.createService());
        }
        if (this.isLeftInterface) {
            if (this.fb.getService().getLeftInterface() == null) {
                this.fb.getService().setLeftInterface(LibraryElementFactory.eINSTANCE.createServiceInterface());
                this.oldName = "";
            } else {
                this.oldName = this.fb.getService().getLeftInterface().getName();
            }
        } else if (this.fb.getService().getRightInterface() == null) {
            this.fb.getService().setRightInterface(LibraryElementFactory.eINSTANCE.createServiceInterface());
            this.oldName = "";
        } else {
            this.oldName = this.fb.getService().getRightInterface().getName();
        }
        this.redo();
    }

    public void undo() {
        if (this.isLeftInterface) {
            this.fb.getService().getLeftInterface().setName(this.oldName);
        } else {
            this.fb.getService().getRightInterface().setName(this.oldName);
        }
    }

    public void redo() {
        if (this.isLeftInterface) {
            this.fb.getService().getLeftInterface().setName(this.name);
        } else {
            this.fb.getService().getRightInterface().setName(this.name);
        }
    }
}

