/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangeSequenceNameCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateTransactionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteInputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteOutputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteTransactionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.contentprovider.ServiceSequenceContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties.AbstractServiceSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ServiceSequenceSection
extends AbstractServiceSection {
    private Text nameText;
    private Text commentText;
    private TreeViewer transactionViewer;
    private Button transactionNew;
    private Button transactionDelete;

    protected ServiceSequence getType() {
        return (ServiceSequence)this.type;
    }

    protected ServiceSequence getInputType(Object input) {
        if (input instanceof ServiceSequenceEditPart) {
            return ((ServiceSequenceEditPart)((Object)input)).getCastedModel();
        }
        if (input instanceof ServiceSequence) {
            return (ServiceSequence)input;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createTypeAndCommentSection(this.getLeftComposite());
        this.createTransactionSection(this.getRightComposite());
    }

    private void createTypeAndCommentSection(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, "Name:");
        this.nameText = this.createGroupText(composite, true);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceSequenceSection.this.removeContentAdapter();
                ServiceSequenceSection.this.executeCommand(new ChangeSequenceNameCommand(ServiceSequenceSection.this.nameText.getText(), ServiceSequenceSection.this.getType()));
                ServiceSequenceSection.this.addContentAdapter();
            }
        });
        this.getWidgetFactory().createCLabel(composite, "Comment:");
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceSequenceSection.this.removeContentAdapter();
                ServiceSequenceSection.this.executeCommand((Command)new ChangeCommentCommand((INamedElement)ServiceSequenceSection.this.getType(), ServiceSequenceSection.this.commentText.getText()));
                ServiceSequenceSection.this.addContentAdapter();
            }
        });
    }

    private void createTransactionSection(Composite parent) {
        Group transactionGroup = this.getWidgetFactory().createGroup(parent, "Transaction");
        transactionGroup.setLayout((Layout)new GridLayout(2, false));
        transactionGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.transactionViewer = new TreeViewer((Composite)transactionGroup, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 150;
        gridData.widthHint = 80;
        this.transactionViewer.getTree().setLayoutData((Object)gridData);
        this.transactionViewer.setContentProvider((IContentProvider)new ServiceSequenceContentProvider());
        this.transactionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
        new AdapterFactoryTreeEditor(this.transactionViewer.getTree(), (AdapterFactory)this.getAdapterFactory());
        this.transactionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        Composite buttonComp = new Composite((Composite)transactionGroup, 0);
        buttonComp.setLayout((Layout)new FillLayout(512));
        this.transactionNew = this.getWidgetFactory().createButton(buttonComp, "New", 8);
        this.transactionNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.transactionNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServiceSequenceSection.this.executeCommand(new CreateTransactionCommand(ServiceSequenceSection.this.getType()));
                ServiceSequenceSection.this.transactionViewer.refresh();
            }
        });
        this.transactionDelete = this.getWidgetFactory().createButton(buttonComp, "Delete", 8);
        this.transactionDelete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.transactionDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = ((TreeSelection)ServiceSequenceSection.this.transactionViewer.getSelection()).getFirstElement();
                if (selection instanceof ServiceTransaction) {
                    ServiceSequenceSection.this.executeCommand(new DeleteTransactionCommand((ServiceTransaction)selection));
                } else if (selection instanceof InputPrimitive) {
                    ServiceSequenceSection.this.executeCommand(new DeleteInputPrimitiveCommand((InputPrimitive)selection));
                } else if (selection instanceof OutputPrimitive) {
                    ServiceSequenceSection.this.executeCommand(new DeleteOutputPrimitiveCommand((OutputPrimitive)selection));
                }
                ServiceSequenceSection.this.transactionViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.nameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            this.transactionViewer.setInput((Object)this.getType());
        }
        this.commandStack = commandStackBuffer;
    }

    protected void setInputCode() {
        this.nameText.setEnabled(false);
        this.commentText.setEnabled(false);
        this.transactionViewer.setInput(null);
    }

    protected void setInputInit() {
    }
}

