/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.AbstractContainerElement;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.EventInputContainer;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.EventOutputContainer;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InterfaceContainerEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.PlugContainer;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.SocketContainer;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.VariableInputContainer;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.VariableOutputContainer;
import org.eclipse.fordiac.ide.fbtypeeditor.figures.FBTypeFigure;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class FBTypeEditPart
extends AbstractDirectEditableEditPart {
    private ControlListener controlListener;
    private ZoomManager zoomManager;
    private EventInputContainer eic;
    private EventOutputContainer eoc;
    private VariableInputContainer vic;
    private SocketContainer socketcont;
    private VariableOutputContainer voc;
    private PlugContainer plugcont;
    private DiagramFontChangeListener fontChangeListener;
    private final EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (8 != notification.getEventType()) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getVersionInfo().equals(feature) || LibraryElementPackage.eINSTANCE.getVersionInfo_Version().equals(feature)) {
                    FBTypeEditPart.this.getFigure().updateVersionInfoLabel();
                }
                Display.getDefault().asyncExec(() -> {
                    if (FBTypeEditPart.this.getFigure() != null && FBTypeEditPart.this.getFigure().isShowing()) {
                        FBTypeEditPart.this.refresh();
                    }
                });
            }
        }
    };

    public void activate() {
        super.activate();
        this.getModel().eAdapters().add((Object)this.adapter);
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
    }

    public void deactivate() {
        super.deactivate();
        this.getModel().eAdapters().remove((Object)this.adapter);
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    public FBType getModel() {
        return (FBType)super.getModel();
    }

    FBTypeEditPart(ZoomManager zoomManager) {
        this.zoomManager = zoomManager;
    }

    protected IFigure createFigure() {
        return new FBTypeFigure(this.getModel(), this.zoomManager);
    }

    public void setSelected(int value) {
    }

    public void refreshName() {
        Display.getDefault().asyncExec(() -> this.getNameLabel().setText(this.getINamedElement().getName()));
    }

    protected List getModelChildren() {
        if (this.eic == null) {
            this.eic = new EventInputContainer(this.getModel());
        }
        if (this.eoc == null) {
            this.eoc = new EventOutputContainer(this.getModel());
        }
        if (this.vic == null) {
            this.vic = new VariableInputContainer(this.getModel());
        }
        if (this.socketcont == null) {
            this.socketcont = new SocketContainer(this.getModel());
        }
        if (this.voc == null) {
            this.voc = new VariableOutputContainer(this.getModel());
        }
        if (this.plugcont == null) {
            this.plugcont = new PlugContainer(this.getModel());
        }
        ArrayList<AbstractContainerElement> temp = new ArrayList<AbstractContainerElement>(6);
        temp.add(this.eic);
        temp.add(this.eoc);
        temp.add(this.vic);
        if (!(this.getModel() instanceof AdapterFBType)) {
            temp.add(this.socketcont);
        }
        temp.add(this.voc);
        if (!(this.getModel() instanceof AdapterFBType)) {
            temp.add(this.plugcont);
        }
        return temp;
    }

    public FBTypeFigure getFigure() {
        return (FBTypeFigure)super.getFigure();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof InterfaceContainerEditPart) {
            if (childEditPart.getModel() instanceof EventInputContainer) {
                this.getFigure().getInputEvents().add(child);
            }
            if (childEditPart.getModel() instanceof EventOutputContainer) {
                this.getFigure().getOutputEvents().add(child);
            }
            if (childEditPart.getModel() instanceof VariableInputContainer) {
                this.getFigure().getInputVariables().add(child);
            }
            if (childEditPart.getModel() instanceof VariableOutputContainer) {
                this.getFigure().getOutputVariables().add(child);
            }
            if (childEditPart.getModel() instanceof SocketContainer) {
                this.getFigure().getSockets().add(child);
            }
            if (childEditPart.getModel() instanceof PlugContainer) {
                this.getFigure().getPlugs().add(child);
            }
        } else {
            super.addChildVisual(childEditPart, index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof InterfaceContainerEditPart) {
            if (childEditPart.getModel() instanceof EventInputContainer) {
                this.getFigure().getInputEvents().remove(child);
            }
            if (childEditPart.getModel() instanceof EventOutputContainer) {
                this.getFigure().getOutputEvents().remove(child);
            }
            if (childEditPart.getModel() instanceof VariableInputContainer) {
                this.getFigure().getInputVariables().remove(child);
            }
            if (childEditPart.getModel() instanceof VariableOutputContainer) {
                this.getFigure().getOutputVariables().remove(child);
            }
            if (childEditPart.getModel() instanceof SocketContainer) {
                this.getFigure().getSockets().remove(child);
            }
            if (childEditPart.getModel() instanceof PlugContainer) {
                this.getFigure().getPlugs().remove(child);
            }
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    private void update(Rectangle bounds) {
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getFigure(), (Object)bounds);
    }

    protected void refreshVisuals() {
        if (this.controlListener == null) {
            this.controlListener = new ControlListener(){

                public void controlResized(ControlEvent e) {
                    Point p = FBTypeEditPart.this.getParent().getViewer().getControl().getSize();
                    Dimension dim = FBTypeEditPart.this.getFigure().getPreferredSize(-1, -1);
                    Rectangle rect = new Rectangle(p.x / 2 - dim.width / 2, p.y / 2 - dim.height / 2, -1, -1);
                    FBTypeEditPart.this.update(rect);
                }

                public void controlMoved(ControlEvent e) {
                }
            };
            this.getParent().getViewer().getControl().addControlListener(this.controlListener);
        }
        Point p = this.getParent().getViewer().getControl().getSize();
        Dimension dim = this.getFigure().getPreferredSize(-1, -1);
        Rectangle rect = new Rectangle(p.x / 2 - dim.width / 2, p.y / 2 - dim.height / 2, -1, -1);
        this.update(rect);
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    public Label getNameLabel() {
        return this.getFigure().getTypeNameLabel();
    }
}

