/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;

public class PropertyChangeHandler {
    private ListenerList<IPropertyChangeListener> fListeners = new ListenerList(1);

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void firePropertyChange(Object source, String property, Object oldValue, Object newValue) {
        PropertyNotifier notifier = new PropertyNotifier();
        notifier.notify(new PropertyChangeEvent(source, property, oldValue, newValue));
    }

    class PropertyNotifier
    implements ISafeRunnable {
        private IPropertyChangeListener fListener;
        private PropertyChangeEvent fEvent;

        PropertyNotifier() {
        }

        public void handleException(Throwable exception) {
            TeamUIPlugin.log(4, TeamUIMessages.AbstractSynchronizeParticipant_5, exception);
        }

        public void run() throws Exception {
            this.fListener.propertyChange(this.fEvent);
        }

        public void notify(PropertyChangeEvent event) {
            Object[] copiedListeners;
            if (PropertyChangeHandler.this.fListeners == null) {
                return;
            }
            this.fEvent = event;
            Object[] objectArray = copiedListeners = PropertyChangeHandler.this.fListeners.getListeners();
            int n = copiedListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object copiedListener = objectArray[n2];
                this.fListener = (IPropertyChangeListener)copiedListener;
                SafeRunner.run((ISafeRunnable)this);
                ++n2;
            }
            this.fListener = null;
        }
    }
}

