/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.metrics.analyzers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.metrics.analyzers.AbstractCodeMetricAnalyzer;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricData;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class HalsteadMetric
extends AbstractCodeMetricAnalyzer {
    private static final int ST_OPERATOR_COUNT = 16;
    private static final String[] ST_OPERATORS = new String[]{"**", ":=", "<=", ">=", "<>", "-", "NOT", "*", "/", "MOD", "+", "<", ">", "=", "AND", "OR", "XOR"};
    private static final int[] ST_OPERANDS_WEIGHT = new int[]{1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private double operandST = 0.0;
    private double operatorST = 0.0;
    private double uniqueOperatorST = 0.0;
    private double operators = 0.0;
    private double operands = 0.0;
    private double uniqueOperands = 0.0;
    private double uniqueOperator = 0.0;
    private int actionCount = 0;
    private int[] opCount = new int[16];
    private int uniqueTrans = 0;
    private List<String> alg = new ArrayList<String>();
    private List<String> transCond = new ArrayList<String>();
    private List<String> actions = new ArrayList<String>();
    private List<String> event = new ArrayList<String>();

    @Override
    public void calculateMetrics(INamedElement element) {
        super.calculateMetrics(element);
        this.uniqueOperands += (double)this.uniqueTrans;
        this.uniqueOperator += (double)this.uniqueTrans;
        this.operators += (double)(this.actions.size() + this.transCond.size());
        this.operands += (double)(this.event.size() + this.alg.size() + this.transCond.size());
        int i = 0;
        while (i < this.opCount.length) {
            if ((double)this.opCount[i] >= 1.0) {
                this.uniqueOperatorST += 1.0;
            }
            ++i;
        }
    }

    @Override
    protected void analyzeBFB(BasicFBType basicFBType) {
        ECC ecc = basicFBType.getECC();
        for (ECTransition trans : ecc.getECTransition()) {
            if (!this.transCond.contains(trans.getConditionExpression())) {
                ++this.uniqueTrans;
            }
            this.transCond.add(trans.getConditionExpression());
        }
        for (ECState state : ecc.getECState()) {
            for (ECAction action : state.getECAction()) {
                this.analyzeAction(action);
            }
        }
    }

    private void analyzeAction(ECAction action) {
        if (!this.actions.contains("Action " + this.actionCount)) {
            this.uniqueOperator += 1.0;
        }
        this.actions.add("Action " + this.actionCount);
        if (action.getOutput() != null) {
            if (!this.event.contains(action.getOutput().getName())) {
                this.uniqueOperands += 1.0;
            }
            this.event.add(action.getOutput().getName());
        }
        if (action.getAlgorithm() != null) {
            this.analyzeAlgorithm(action.getAlgorithm());
        }
        ++this.actionCount;
    }

    private void analyzeAlgorithm(Algorithm algorithm) {
        if (!this.alg.contains(algorithm.getName())) {
            this.uniqueOperands += 1.0;
        }
        this.alg.add(algorithm.getName());
        String algo = algorithm.toString();
        int count = 0;
        String[] stringArray = ST_OPERATORS;
        int n = ST_OPERATORS.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            int lastIndex = 0;
            while (-1 != lastIndex) {
                if (-1 == (lastIndex = algo.indexOf(op, lastIndex))) continue;
                this.operatorST += 1.0;
                int n3 = count;
                this.opCount[n3] = this.opCount[n3] + 1;
                this.operandST += (double)ST_OPERANDS_WEIGHT[count];
                String sub1 = algo.substring(0, lastIndex);
                String sub2 = algo.substring(lastIndex + op.length(), algo.length());
                algo = sub1.concat(sub2);
            }
            ++count;
            ++n2;
        }
    }

    @Override
    public List<MetricData> getResults() {
        double n2Major = this.operands + this.operandST;
        double n2 = this.uniqueOperands + this.operandST;
        double n1Major = this.operators + this.operatorST;
        double n1 = this.uniqueOperator + this.uniqueOperatorST;
        ArrayList<MetricData> results = new ArrayList<MetricData>();
        results.add(new MetricData("Distinct operators ", n1));
        results.add(new MetricData("Distinct operands ", n2));
        results.add(new MetricData("Total number of operators ", n1Major));
        results.add(new MetricData("Total number of operands ", n2Major));
        results.add(new MetricData("Distinct operators ST ", this.uniqueOperatorST));
        results.add(new MetricData("Distinct operands ST ", this.operandST));
        results.add(new MetricData("Total number of operators ST ", this.operatorST));
        results.add(new MetricData("Total number of operands ST ", this.operandST));
        double nMAjor = n1Major + n2Major;
        double n = n1 + n2;
        double nHat = n1 * Math.log(n1) / Math.log(2.0) + n2 * Math.log(n2) / Math.log(2.0);
        double pr = nHat / nMAjor;
        double v = nMAjor * Math.log(n) / Math.log(2.0);
        double d = n1 / 2.0 * n2Major / n2;
        double e = d * v;
        results.add(new MetricData("Program Length ", nMAjor));
        results.add(new MetricData("Program vocabulary ", n));
        results.add(new MetricData("Estimated length ", nHat));
        results.add(new MetricData("Purity ratio ", pr));
        results.add(new MetricData("Program volume ", v));
        results.add(new MetricData("Difficulty ", d));
        results.add(new MetricData("Program Effort ", e));
        return results;
    }
}

