/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.properties;

import java.util.List;
import org.eclipse.fordiac.ide.deployment.Activator;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.iec61499.DynamicTypeLoadDeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.gef.commands.ChangeProfileCommand;
import org.eclipse.fordiac.ide.gef.properties.AbstractInterfaceSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DeviceSection
extends AbstractInterfaceSection {
    protected static String[] profileNames;
    protected CCombo profile;
    protected Button getResources;

    protected CommandStack getCommandStack(IWorkbenchPart part, Object input) {
        Device helper = this.getInputType(input);
        if (helper != null) {
            return SystemManager.INSTANCE.getCommandStack(helper.getAutomationSystem());
        }
        return null;
    }

    public void refresh() {
        super.refresh();
        if (this.type != null) {
            this.setProfile();
            this.getResources.setEnabled("DynamicTypeLoad".equals(((Device)this.getType()).getProfile()));
        }
    }

    private void setProfile() {
        int i = 0;
        String[] stringArray = this.profile.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.equals(((Device)this.getType()).getProfile())) {
                this.profile.select(i);
                break;
            }
            ++i;
            ++n2;
        }
    }

    protected Device getInputType(Object input) {
        if (input instanceof EditPart) {
            input = ((EditPart)input).getModel();
        }
        if (input instanceof Device) {
            return (Device)input;
        }
        return null;
    }

    protected void createFBInfoGroup(Composite parent) {
        this.createDeviceInterfaceTab(parent);
        this.profile.setItems(DeviceSection.getAvailableProfileNames());
        this.getResources.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IDeviceManagementInteractor interactor;
                if (DeviceSection.this.type instanceof Device && (interactor = DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor((Device)DeviceSection.this.getType())) instanceof DynamicTypeLoadDeploymentExecutor) {
                    block12: {
                        DeploymentCoordinator.INSTANCE.enableOutput(interactor);
                        try {
                            try {
                                interactor.connect();
                                ((DynamicTypeLoadDeploymentExecutor)interactor).queryResourcesWithNetwork((Device)DeviceSection.this.getType());
                            }
                            catch (Exception e) {
                                Activator.getDefault().logError(e.getMessage(), e);
                                try {
                                    interactor.disconnect();
                                }
                                catch (DeploymentException e2) {
                                    Activator.getDefault().logError(e2.getMessage(), (Exception)((Object)e2));
                                }
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                interactor.disconnect();
                            }
                            catch (DeploymentException e) {
                                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                            }
                            throw throwable;
                        }
                        try {
                            interactor.disconnect();
                        }
                        catch (DeploymentException e) {
                            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                        }
                    }
                    DeploymentCoordinator.INSTANCE.disableOutput(interactor);
                }
            }
        });
    }

    private void createDeviceInterfaceTab(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, "Instance Name:");
        this.nameText = this.createGroupText(composite, true);
        this.nameText.addModifyListener(event -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeNameCommand(this.getType(), this.nameText.getText()));
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(composite, "Profile:");
        this.profile = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)composite);
        this.profile.addListener(13, event -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeProfileCommand((Device)this.getType(), this.profile.getText()));
            this.refresh();
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(composite, "Instance Comment:");
        this.commentText = this.createGroupText(composite, true);
        GridData gridData = new GridData(4, 0, true, false);
        this.commentText.setLayoutData((Object)gridData);
        this.commentText.addModifyListener(event -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeCommentCommand(this.getType(), this.commentText.getText()));
            this.addContentAdapter();
        });
        this.getResources = this.getWidgetFactory().createButton(composite, "Fetch Resource", 8);
        this.getResources.setToolTipText("Fetch the resources currently running in the device.");
        GridData getResGridData = new GridData(4, 0, false, false);
        getResGridData.horizontalSpan = 2;
        this.getResources.setLayoutData((Object)getResGridData);
    }

    protected static String[] getAvailableProfileNames() {
        if (profileNames == null) {
            List newProfileNames = DeviceManagementInteractorFactory.INSTANCE.getAvailableProfileNames();
            profileNames = newProfileNames.toArray(new String[newProfileNames.size()]);
        }
        return profileNames;
    }
}

