/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.st;

import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.structuredtext.parser.antlr.StructuredTextParser;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.AdapterVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ArrayVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.AssignmentStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.BinaryExpression;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.BinaryOperator;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.BoolLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Call;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.CaseClause;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.CaseStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Constant;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ContinueStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ElseClause;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ElseIfClause;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ExitStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Expression;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ForStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.IfStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.IntLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.LocalVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.PrimaryVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.RealLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.RepeatStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ReturnStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Statement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StatementList;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StringLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StructuredTextAlgorithm;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.UnaryExpression;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.UnaryOperator;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.WhileStatement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class STAlgorithmFilter {
    private static final URI SYNTHETIC_FB_URI = URI.createFileURI((String)"__synthetic.xtextfbt");
    private static final URI SYNTHETIC_ST_URI = URI.createFileURI((String)"__synthetic.st");
    private static final IResourceServiceProvider SERVICE_PROVIDER = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(SYNTHETIC_ST_URI);

    public CharSequence generate(STAlgorithm alg, List<String> errors) {
        IParseResult parseResult;
        block3: {
            try {
                ResourceSet resourceSet = (ResourceSet)SERVICE_PROVIDER.get(ResourceSet.class);
                Resource fbResource = resourceSet.createResource(SYNTHETIC_FB_URI);
                EObject fbCopy = EcoreUtil.copy((EObject)EcoreUtil.getRootContainer((EObject)alg));
                fbResource.getContents().add((Object)fbCopy);
                Resource _createResource = resourceSet.createResource(SYNTHETIC_ST_URI);
                XtextResource resource = (XtextResource)_createResource;
                String _text = alg.getText();
                LazyStringInputStream _lazyStringInputStream = new LazyStringInputStream(_text);
                Pair _mappedTo = Pair.of((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
                resource.load((InputStream)_lazyStringInputStream, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
                parseResult = resource.getParseResult();
                boolean _hasSyntaxErrors = parseResult.hasSyntaxErrors();
                if (!_hasSyntaxErrors) break block3;
                Functions.Function1 _function = it -> it.getSyntaxErrorMessage().getMessage();
                Iterables.addAll(errors, (Iterable)IterableExtensions.map((Iterable)parseResult.getSyntaxErrors(), (Functions.Function1)_function));
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        EObject _rootASTElement = parseResult.getRootASTElement();
        StructuredTextAlgorithm stalg = (StructuredTextAlgorithm)_rootASTElement;
        return this.generateStructuredTextAlgorithm(stalg);
    }

    public CharSequence generate(String expression, BasicFBType fb, List<String> errors) {
        IParseResult parseResult;
        block3: {
            try {
                ResourceSet resourceSet = (ResourceSet)SERVICE_PROVIDER.get(ResourceSet.class);
                Resource fbResource = resourceSet.createResource(SYNTHETIC_FB_URI);
                BasicFBType fbCopy = (BasicFBType)EcoreUtil.copy((EObject)fb);
                fbResource.getContents().add((Object)fbCopy);
                Resource _createResource = resourceSet.createResource(SYNTHETIC_ST_URI);
                XtextResource resource = (XtextResource)_createResource;
                IParser _parser = resource.getParser();
                StructuredTextParser parser = (StructuredTextParser)_parser;
                LazyStringInputStream _lazyStringInputStream = new LazyStringInputStream(expression);
                ParserRule _expressionRule = parser.getGrammarAccess().getExpressionRule();
                Pair _mappedTo = Pair.of((Object)"PARSER_RULE", (Object)_expressionRule);
                resource.load((InputStream)_lazyStringInputStream, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
                parseResult = resource.getParseResult();
                boolean _hasSyntaxErrors = parseResult.hasSyntaxErrors();
                if (!_hasSyntaxErrors) break block3;
                Functions.Function1 _function = it -> it.getSyntaxErrorMessage().getMessage();
                Iterables.addAll(errors, (Iterable)IterableExtensions.map((Iterable)parseResult.getSyntaxErrors(), (Functions.Function1)_function));
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        EObject _rootASTElement = parseResult.getRootASTElement();
        Expression expr = (Expression)_rootASTElement;
        return this.generateExpression(expr);
    }

    protected CharSequence generateStructuredTextAlgorithm(StructuredTextAlgorithm alg) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateLocalVariables = this.generateLocalVariables((List<VarDeclaration>)alg.getLocalVariables());
        _builder.append((Object)_generateLocalVariables);
        _builder.newLineIfNotEmpty();
        CharSequence _generateStatementList = this.generateStatementList(alg.getStatements());
        _builder.append((Object)_generateStatementList);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateLocalVariables(List<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        for (VarDeclaration variable : variables) {
            _builder.append("CIEC_");
            String _name = variable.getType().getName();
            _builder.append(_name);
            _builder.append(" ");
            String _name_1 = variable.getName();
            _builder.append(_name_1);
            CharSequence _generateLocalVariableInitializer = this.generateLocalVariableInitializer(variable);
            _builder.append((Object)_generateLocalVariableInitializer);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateLocalVariableInitializer(VarDeclaration variable) {
        String _switchResult = null;
        boolean _matched = false;
        if (variable instanceof LocalVariable) {
            boolean _tripleNotEquals;
            Constant _initialValue = ((LocalVariable)variable).getInitialValue();
            boolean bl = _tripleNotEquals = _initialValue != null;
            if (_tripleNotEquals) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(" ");
                _builder.append("= ");
                CharSequence _generateExpression = this.generateExpression((Expression)((LocalVariable)variable).getInitialValue());
                _builder.append((Object)_generateExpression, " ");
                _switchResult = _builder;
            }
        }
        if (!_matched) {
            _switchResult = "";
        }
        return _switchResult;
    }

    protected CharSequence generateStatementList(StatementList list) {
        StringConcatenation _builder = new StringConcatenation();
        EList _statements = list.getStatements();
        for (Statement stmt : _statements) {
            CharSequence _generateStatement = this.generateStatement(stmt);
            _builder.append((Object)_generateStatement);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateStatement(Statement stmt) {
        EClass _eClass = stmt.eClass();
        String _plus = _eClass + " not supported";
        throw new UnsupportedOperationException(_plus);
    }

    protected CharSequence _generateStatement(AssignmentStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression((Expression)stmt.getVariable());
        _builder.append((Object)_generateExpression);
        _builder.append(" = ");
        CharSequence _generateExpression_1 = this.generateExpression(stmt.getExpression());
        _builder.append((Object)_generateExpression_1);
        _builder.append(";");
        return _builder;
    }

    protected CharSequence _generateStatement(Call stmt) {
        return this.generateExpression((Expression)stmt);
    }

    protected CharSequence _generateStatement(ReturnStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return;");
        return _builder;
    }

    protected CharSequence _generateStatement(IfStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if(");
        CharSequence _generateExpression = this.generateExpression(stmt.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList(stmt.getStatments());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        EList _elseif = stmt.getElseif();
        for (ElseIfClause elseif : _elseif) {
            _builder.append("else if(");
            CharSequence _generateExpression_1 = this.generateExpression(elseif.getExpression());
            _builder.append((Object)_generateExpression_1);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            CharSequence _generateStatementList_1 = this.generateStatementList(elseif.getStatements());
            _builder.append((Object)_generateStatementList_1, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        ElseClause _else = stmt.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            _builder.append("else {");
            _builder.newLine();
            _builder.append("  ");
            CharSequence _generateStatementList_2 = this.generateStatementList(stmt.getElse().getStatements());
            _builder.append((Object)_generateStatementList_2, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateStatement(CaseStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local function case(val)");
        _builder.newLine();
        _builder.append("  ");
        EList _case = stmt.getCase();
        boolean _hasElements = false;
        for (CaseClause clause : _case) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("if ", "  ");
            } else {
                _builder.appendImmediate((Object)"\nelseif ", "  ");
            }
            CharSequence _generateCaseClause = this.generateCaseClause(clause);
            _builder.append((Object)_generateCaseClause, "  ");
        }
        _builder.newLineIfNotEmpty();
        ElseClause _else = stmt.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            _builder.append("  ");
            _builder.append("else");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("  ");
            CharSequence _generateStatementList = this.generateStatementList(stmt.getElse().getStatements());
            _builder.append((Object)_generateStatementList, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("  ");
        _builder.append("end");
        _builder.newLine();
        _builder.append("end");
        _builder.newLine();
        _builder.append("case(");
        CharSequence _generateExpression = this.generateExpression(stmt.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateCaseClause(CaseClause clause) {
        StringConcatenation _builder = new StringConcatenation();
        EList _case = clause.getCase();
        boolean _hasElements = false;
        for (Constant value : _case) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" or ", "");
            }
            _builder.append("val == ");
            CharSequence _generateExpression = this.generateExpression((Expression)value);
            _builder.append((Object)_generateExpression);
        }
        _builder.append(" then");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList(clause.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateStatement(ExitStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("break;");
        return _builder;
    }

    protected CharSequence _generateStatement(ContinueStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("continue;");
        return _builder;
    }

    protected CharSequence _generateStatement(ForStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("for ");
        CharSequence _generateExpression = this.generateExpression((Expression)stmt.getVariable());
        _builder.append((Object)_generateExpression);
        _builder.append(" = ");
        CharSequence _generateExpression_1 = this.generateExpression(stmt.getFrom());
        _builder.append((Object)_generateExpression_1);
        _builder.append(", ");
        CharSequence _generateExpression_2 = this.generateExpression(stmt.getTo());
        _builder.append((Object)_generateExpression_2);
        Expression _by = stmt.getBy();
        boolean bl = _tripleNotEquals = _by != null;
        if (_tripleNotEquals) {
            _builder.append(", ");
            CharSequence _generateExpression_3 = this.generateExpression(stmt.getBy());
            _builder.append((Object)_generateExpression_3);
        }
        _builder.append(" do");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList(stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateStatement(WhileStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("while(");
        CharSequence _generateExpression = this.generateExpression(stmt.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList(stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateStatement(RepeatStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("do {");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList(stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("} while(!((");
        CharSequence _generateExpression = this.generateExpression(stmt.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(")));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateExpression(Expression expr) {
        EClass _eClass = expr.eClass();
        String _plus = _eClass + " not supported";
        throw new UnsupportedOperationException(_plus);
    }

    protected CharSequence _generateExpression(BinaryExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" ");
        CharSequence _generateBinaryOperator = this.generateBinaryOperator(expr.getOperator());
        _builder.append((Object)_generateBinaryOperator);
        _builder.append(" ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence generateBinaryOperator(BinaryOperator op) {
        String _switchResult;
        block17: {
            block16: {
                _switchResult = null;
                if (op == null) break block16;
                switch (op) {
                    case OR: {
                        _switchResult = "||";
                        break block17;
                    }
                    case XOR: {
                        _switchResult = "^";
                        break block17;
                    }
                    case AND: {
                        _switchResult = "&&";
                        break block17;
                    }
                    case EQ: {
                        _switchResult = "==";
                        break block17;
                    }
                    case NE: {
                        _switchResult = "!=";
                        break block17;
                    }
                    case LT: {
                        _switchResult = "<";
                        break block17;
                    }
                    case LE: {
                        _switchResult = "<=";
                        break block17;
                    }
                    case GT: {
                        _switchResult = ">";
                        break block17;
                    }
                    case GE: {
                        _switchResult = ">=";
                        break block17;
                    }
                    case ADD: {
                        _switchResult = "+";
                        break block17;
                    }
                    case SUB: {
                        _switchResult = "-";
                        break block17;
                    }
                    case MUL: {
                        _switchResult = "*";
                        break block17;
                    }
                    case DIV: {
                        _switchResult = "/";
                        break block17;
                    }
                    case MOD: {
                        _switchResult = "%";
                        break block17;
                    }
                    default: {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("The operator ");
                        _builder.append((Object)op);
                        _builder.append(" is not supported");
                        throw new UnsupportedOperationException(_builder.toString());
                    }
                }
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The operator ");
            _builder.append((Object)op);
            _builder.append(" is not supported");
            throw new UnsupportedOperationException(_builder.toString());
        }
        return _switchResult;
    }

    protected CharSequence _generateExpression(UnaryExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateUnaryOperator = this.generateUnaryOperator(expr.getOperator());
        _builder.append((Object)_generateUnaryOperator);
        _builder.append(" ");
        CharSequence _generateExpression = this.generateExpression(expr.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence generateUnaryOperator(UnaryOperator op) {
        String _switchResult = null;
        if (op != null) {
            switch (op) {
                case MINUS: {
                    _switchResult = "-";
                    break;
                }
                case PLUS: {
                    _switchResult = "+";
                    break;
                }
                case NOT: {
                    _switchResult = "!";
                    break;
                }
            }
        }
        return _switchResult;
    }

    protected CharSequence _generateExpression(BoolLiteral expr) {
        return Boolean.toString(expr.isValue());
    }

    protected CharSequence _generateExpression(IntLiteral expr) {
        return Long.toString(expr.getValue());
    }

    protected CharSequence _generateExpression(RealLiteral expr) {
        return Double.toString(expr.getValue());
    }

    protected CharSequence _generateExpression(StringLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _convertToJavaString = Strings.convertToJavaString((String)expr.getValue());
        _builder.append(_convertToJavaString);
        _builder.append("\"");
        return _builder;
    }

    protected CharSequence _generateExpression(ArrayVariable expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression((Expression)expr.getArray());
        _builder.append((Object)_generateExpression);
        EList _index = expr.getIndex();
        boolean _hasElements = false;
        for (Expression index : _index) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("[");
            } else {
                _builder.appendImmediate((Object)"][", "");
            }
            _builder.append("(");
            CharSequence _generateExpression_1 = this.generateExpression(index);
            _builder.append((Object)_generateExpression_1);
            _builder.append(") + 1");
        }
        if (_hasElements) {
            _builder.append("]");
        }
        return _builder;
    }

    protected CharSequence _generateExpression(AdapterVariable expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = expr.getAdapter().getName();
        _builder.append(_name);
        _builder.append("().");
        String _name_1 = expr.getVar().getName();
        _builder.append(_name_1);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _generateExpression(PrimaryVariable expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = expr.getVar().getName();
        _builder.append(_name);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence generateStatement(Statement stmt) {
        if (stmt instanceof AssignmentStatement) {
            return this._generateStatement((AssignmentStatement)stmt);
        }
        if (stmt instanceof Call) {
            return this._generateStatement((Call)stmt);
        }
        if (stmt instanceof CaseStatement) {
            return this._generateStatement((CaseStatement)stmt);
        }
        if (stmt instanceof ContinueStatement) {
            return this._generateStatement((ContinueStatement)stmt);
        }
        if (stmt instanceof ExitStatement) {
            return this._generateStatement((ExitStatement)stmt);
        }
        if (stmt instanceof ForStatement) {
            return this._generateStatement((ForStatement)stmt);
        }
        if (stmt instanceof IfStatement) {
            return this._generateStatement((IfStatement)stmt);
        }
        if (stmt instanceof RepeatStatement) {
            return this._generateStatement((RepeatStatement)stmt);
        }
        if (stmt instanceof ReturnStatement) {
            return this._generateStatement((ReturnStatement)stmt);
        }
        if (stmt instanceof WhileStatement) {
            return this._generateStatement((WhileStatement)stmt);
        }
        if (stmt != null) {
            return this._generateStatement(stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    protected CharSequence generateExpression(Expression expr) {
        if (expr instanceof IntLiteral) {
            return this._generateExpression((IntLiteral)expr);
        }
        if (expr instanceof RealLiteral) {
            return this._generateExpression((RealLiteral)expr);
        }
        if (expr instanceof AdapterVariable) {
            return this._generateExpression((AdapterVariable)expr);
        }
        if (expr instanceof ArrayVariable) {
            return this._generateExpression((ArrayVariable)expr);
        }
        if (expr instanceof BoolLiteral) {
            return this._generateExpression((BoolLiteral)expr);
        }
        if (expr instanceof PrimaryVariable) {
            return this._generateExpression((PrimaryVariable)expr);
        }
        if (expr instanceof StringLiteral) {
            return this._generateExpression((StringLiteral)expr);
        }
        if (expr instanceof BinaryExpression) {
            return this._generateExpression((BinaryExpression)expr);
        }
        if (expr instanceof UnaryExpression) {
            return this._generateExpression((UnaryExpression)expr);
        }
        if (expr != null) {
            return this._generateExpression(expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }
}

