/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public final class TableWidgetFactory {
    public static TableViewer createTableViewer(Composite parent) {
        return TableWidgetFactory.createTableViewer(parent, 0);
    }

    public static TableViewer createTableViewer(Composite parent, int style) {
        GridData gridData = new GridData(4, 4, true, true);
        TableViewer tableViewer = TableWidgetFactory.createGenericTableViewer(gridData, parent, style);
        gridData.heightHint = 150;
        gridData.widthHint = 80;
        return tableViewer;
    }

    public static TableViewer createPropertyTableViewer(Composite parent) {
        return TableWidgetFactory.createPropertyTableViewer(parent, 0);
    }

    public static TableViewer createPropertyTableViewer(Composite parent, int style) {
        GridData gridData = new GridData(4, 4, true, true);
        TableViewer tableViewer = TableWidgetFactory.createGenericTableViewer(gridData, parent, style);
        gridData.minimumHeight = 80;
        gridData.heightHint = 4;
        gridData.widthHint = 400;
        return tableViewer;
    }

    private static TableViewer createGenericTableViewer(GridData gridData, Composite parent, int style) {
        TableViewer tableViewer = new TableViewer(parent, 0x10B02 | style);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)tableViewer, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        tableViewer.getControl().setLayoutData((Object)gridData);
        Table table = tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        return tableViewer;
    }

    private TableWidgetFactory() {
        throw new UnsupportedOperationException("Widget Factory should not be instantiated");
    }
}

