/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.gef.commands.Command;

public class CreateInternalVariableCommand
extends Command {
    private final DataType dataType = DataTypeLibrary.getInstance().getType("BOOL");
    private final BasicFBType fbType;
    private VarDeclaration varDecl;

    public CreateInternalVariableCommand(BasicFBType fbType) {
        this.fbType = fbType;
    }

    public void execute() {
        this.varDecl = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        this.varDecl.setType(this.dataType);
        this.varDecl.setTypeName(this.dataType.getName());
        this.varDecl.setComment("Internal Variable");
        this.varDecl.setArraySize(0);
        Value value = LibraryElementFactory.eINSTANCE.createValue();
        value.setValue("");
        this.varDecl.setValue(value);
        this.redo();
        this.varDecl.setName(NameRepository.createUniqueName((INamedElement)this.varDecl, (String)"INTERNALVAR"));
    }

    public void undo() {
        this.fbType.getInternalVars().remove((Object)this.varDecl);
    }

    public VarDeclaration getVarDecl() {
        return this.varDecl;
    }

    public void redo() {
        this.fbType.getInternalVars().add((Object)this.varDecl);
    }
}

