/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Point;

public final class FBNetworkHelper {
    public static final int Y_OFFSET_FROM_TOP_LEFT_CORNER = 80;
    public static final int X_OFFSET_FROM_TOP_LEFT_CORNER = 150;

    public static FBNetwork copyFBNetWork(FBNetwork srcNetwork, InterfaceList destInterface) {
        FBNetwork dstNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        dstNetwork.getNetworkElements().addAll(EcoreUtil.copyAll(srcNetwork.getNetworkElements()));
        FBNetworkHelper.createConnections(srcNetwork, dstNetwork, destInterface);
        return dstNetwork;
    }

    private static void createConnections(FBNetwork srcNetwork, FBNetwork dstNetwork, InterfaceList destInterface) {
        for (Connection connection : srcNetwork.getEventConnections()) {
            dstNetwork.getEventConnections().add((Object)((EventConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
        for (Connection connection : srcNetwork.getDataConnections()) {
            dstNetwork.getDataConnections().add((Object)((DataConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
        for (Connection connection : srcNetwork.getAdapterConnections()) {
            dstNetwork.getAdapterConnections().add((Object)((AdapterConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
    }

    private static Connection createConnection(FBNetwork srcNetwork, InterfaceList destInterface, FBNetwork dstNetwork, Connection connection) {
        Connection newConn = (Connection)EcoreUtil.copy((EObject)connection);
        newConn.setSource(FBNetworkHelper.getInterfaceElement(connection.getSource(), destInterface, dstNetwork, srcNetwork));
        newConn.setDestination(FBNetworkHelper.getInterfaceElement(connection.getDestination(), destInterface, dstNetwork, srcNetwork));
        return newConn;
    }

    private static IInterfaceElement getInterfaceElement(IInterfaceElement ie, InterfaceList typeInterface, FBNetwork dstNetwork, FBNetwork srcNetwork) {
        if (ie.getFBNetworkElement() == null) {
            return typeInterface.getInterfaceElement(ie.getName());
        }
        if (!srcNetwork.equals(ie.getFBNetworkElement().getFbNetwork())) {
            return typeInterface.getInterfaceElement(ie.getName());
        }
        FBNetworkElement element = dstNetwork.getElementNamed(ie.getFBNetworkElement().getName());
        if (element == null) {
            return null;
        }
        return element.getInterfaceElement(ie.getName());
    }

    public static Point getTopLeftCornerOfFBNetwork(List<?> selection) {
        Assert.isNotNull(selection);
        Point pt = new Point(0, 0);
        Object fb = null;
        for (Object sel : selection) {
            fb = (sel instanceof EditPart ? ((EditPart)sel).getModel() : sel);
            if (!(fb instanceof FBNetworkElement)) continue;
            pt.x = pt.x == 0 ? ((FBNetworkElement)fb).getX() : Math.min(pt.x, ((FBNetworkElement)fb).getX());
            int n = pt.y = pt.y == 0 ? ((FBNetworkElement)fb).getY() : Math.min(pt.y, ((FBNetworkElement)fb).getY());
        }
        return pt;
    }

    public static void moveFBNetworkByOffset(Iterable<FBNetworkElement> fbNetwork, int xOffset, int yOffset) {
        for (FBNetworkElement el : fbNetwork) {
            el.setX(el.getX() - xOffset);
            el.setY(el.getY() - yOffset);
        }
    }

    public static void removeXYOffsetForFBNetwork(List<FBNetworkElement> fbNetwork) {
        Point offset = FBNetworkHelper.getTopLeftCornerOfFBNetwork(fbNetwork);
        FBNetworkHelper.moveFBNetworkByOffset(fbNetwork, offset.x - 150, offset.y - 80);
    }

    public static void moveFBNetworkByOffset(List<FBNetworkElement> fbNetwork, Point offset) {
        FBNetworkHelper.moveFBNetworkByOffset(fbNetwork, offset.x, offset.y);
    }

    private FBNetworkHelper() {
        throw new IllegalStateException("FBNetworkHelper is a utility class that can not be instantiated");
    }
}

