/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangeServiceInterfaceCommentCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangeServiceInterfaceNameCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateServiceSequenceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteInputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteOutputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteServiceSequenceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteTransactionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.SequenceRootEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties.AbstractServiceSection;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ServiceSection
extends AbstractServiceSection {
    private TreeViewer sequencesViewer;
    private Button sequenceNew;
    private Button sequenceDelete;
    private Text leftNameText;
    private Text rightNameText;
    private Text leftCommentText;
    private Text rightCommentText;

    protected FBType getType() {
        return (FBType)this.type;
    }

    protected FBType getInputType(Object input) {
        if (input instanceof SequenceRootEditPart) {
            return (FBType)((SequenceRootEditPart)((Object)input)).getCastedModel().eContainer();
        }
        if (input instanceof Service) {
            return (FBType)((Service)input).eContainer();
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createServiceSection(this.getLeftComposite());
        this.createSequencesSection(this.getRightComposite());
    }

    private void createServiceSection(Composite parent) {
        Group serviceGroup1 = this.getWidgetFactory().createGroup(parent, "Left Interface");
        serviceGroup1.setLayout((Layout)new GridLayout(2, false));
        serviceGroup1.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel((Composite)serviceGroup1, "Name:");
        this.leftNameText = this.createGroupText((Composite)serviceGroup1, true);
        this.leftNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceSection.this.removeContentAdapter();
                ServiceSection.this.executeCommand(new ChangeServiceInterfaceNameCommand(ServiceSection.this.leftNameText.getText(), ServiceSection.this.getType(), true));
                ServiceSection.this.addContentAdapter();
            }
        });
        this.getWidgetFactory().createCLabel((Composite)serviceGroup1, "Comment:");
        this.leftCommentText = this.createGroupText((Composite)serviceGroup1, true);
        this.leftCommentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceSection.this.removeContentAdapter();
                ServiceSection.this.executeCommand(new ChangeServiceInterfaceCommentCommand(ServiceSection.this.leftCommentText.getText(), ServiceSection.this.getType().getService(), true));
                ServiceSection.this.addContentAdapter();
            }
        });
        Group serviceGroup2 = this.getWidgetFactory().createGroup(parent, "Right Interface");
        serviceGroup2.setLayout((Layout)new GridLayout(2, false));
        serviceGroup2.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel((Composite)serviceGroup2, "Name:");
        this.rightNameText = this.createGroupText((Composite)serviceGroup2, true);
        this.rightNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceSection.this.removeContentAdapter();
                ServiceSection.this.executeCommand(new ChangeServiceInterfaceNameCommand(ServiceSection.this.rightNameText.getText(), ServiceSection.this.getType(), false));
                ServiceSection.this.addContentAdapter();
            }
        });
        this.getWidgetFactory().createCLabel((Composite)serviceGroup2, "Comment:");
        this.rightCommentText = this.createGroupText((Composite)serviceGroup2, true);
        this.rightCommentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceSection.this.removeContentAdapter();
                ServiceSection.this.executeCommand(new ChangeServiceInterfaceCommentCommand(ServiceSection.this.rightCommentText.getText(), ServiceSection.this.getType().getService(), false));
                ServiceSection.this.addContentAdapter();
            }
        });
    }

    private void createSequencesSection(Composite parent) {
        Group transactionGroup = this.getWidgetFactory().createGroup(parent, "Service Sequences");
        transactionGroup.setLayout((Layout)new GridLayout(2, false));
        transactionGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.sequencesViewer = new TreeViewer((Composite)transactionGroup, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 150;
        gridData.widthHint = 80;
        this.sequencesViewer.getTree().setLayoutData((Object)gridData);
        this.sequencesViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.getAdapterFactory()));
        this.sequencesViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
        new AdapterFactoryTreeEditor(this.sequencesViewer.getTree(), (AdapterFactory)this.getAdapterFactory());
        this.sequencesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        Composite buttonComp = new Composite((Composite)transactionGroup, 0);
        buttonComp.setLayout((Layout)new FillLayout(512));
        this.sequenceNew = this.getWidgetFactory().createButton(buttonComp, "New", 8);
        this.sequenceNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.sequenceNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServiceSection.this.executeCommand(new CreateServiceSequenceCommand(ServiceSection.this.getType()));
                ServiceSection.this.sequencesViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.sequenceDelete = this.getWidgetFactory().createButton(buttonComp, "Delete", 8);
        this.sequenceDelete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.sequenceDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = ((TreeSelection)ServiceSection.this.sequencesViewer.getSelection()).getFirstElement();
                if (selection instanceof ServiceSequence) {
                    ServiceSection.this.selectNewSequence(null);
                    ServiceSection.this.executeCommand(new DeleteServiceSequenceCommand(ServiceSection.this.getType(), (ServiceSequence)selection));
                } else if (selection instanceof ServiceTransaction) {
                    ServiceSection.this.executeCommand(new DeleteTransactionCommand((ServiceTransaction)selection));
                } else if (selection instanceof InputPrimitive) {
                    ServiceSection.this.executeCommand(new DeleteInputPrimitiveCommand((InputPrimitive)selection));
                } else if (selection instanceof OutputPrimitive) {
                    ServiceSection.this.executeCommand(new DeleteOutputPrimitiveCommand((OutputPrimitive)selection));
                }
                ServiceSection.this.sequencesViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void selectNewSequence(ServiceSequence selectedSequence) {
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.leftNameText.setText(this.getType().getService().getLeftInterface() != null ? this.getType().getService().getLeftInterface().getName() : "");
            this.leftCommentText.setText(this.getType().getService().getLeftInterface() != null && this.getType().getService().getLeftInterface().getComment() != null ? this.getType().getService().getLeftInterface().getComment() : "");
            this.rightNameText.setText(this.getType().getService().getRightInterface() != null ? this.getType().getService().getRightInterface().getName() : "");
            this.rightCommentText.setText(this.getType().getService().getRightInterface() != null && this.getType().getService().getRightInterface().getComment() != null ? this.getType().getService().getRightInterface().getComment() : "");
            this.sequencesViewer.setInput((Object)this.getType().getService());
        }
        this.commandStack = commandStackBuffer;
    }

    protected void setInputCode() {
        this.leftNameText.setEnabled(false);
        this.leftCommentText.setEnabled(false);
        this.rightNameText.setEnabled(false);
        this.rightCommentText.setEnabled(false);
        this.sequencesViewer.setInput(null);
    }

    protected void setInputInit() {
    }
}

