/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fmu.wizard;

import org.eclipse.fordiac.ide.deployment.ui.views.DownloadSelectionTree;
import org.eclipse.fordiac.ide.fmu.Activator;
import org.eclipse.fordiac.ide.fmu.Messages;
import org.eclipse.fordiac.ide.fmu.preferences.FMUPreferencePage;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.DirectoryChooserControl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CreateFMUWizardPage
extends WizardPage {
    private IStructuredSelection selection;
    private DirectoryChooserControl dcc;
    private DownloadSelectionTree systemTree;
    private static final String CURRENT_DIR_SETTING_ID = "currentDir";
    private Button win32Field = null;
    private Button win64Field;
    private Button linux32Field;
    private Button linux64Field;
    private Button storeSelectedLibaries;

    public Button getWin32Field() {
        return this.win32Field;
    }

    public Button getWin64Field() {
        return this.win64Field;
    }

    public Button getLinux32Field() {
        return this.linux32Field;
    }

    public Button getLinux64Field() {
        return this.linux64Field;
    }

    public Button getStoreSelectedLibaries() {
        return this.storeSelectedLibaries;
    }

    public CreateFMUWizardPage(IStructuredSelection selection) {
        super(Messages.FordiacCreateFMUWizard_PageName);
        this.selection = selection;
        this.setDescription(Messages.FordiacCreateFMUWizard_PageDESCRIPTION);
        this.setTitle(Messages.FordiacCreateFMUWizard_PageTITLE);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createSystemsContainer(composite);
        this.createDestinationGroup(composite);
        this.createSelectionLibrariesGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    public Object[] getSelectedElements() {
        return this.systemTree.getCheckedElements();
    }

    private void createSystemsContainer(Composite composite) {
        this.systemTree = new DownloadSelectionTree(composite, 66308);
        GridData fillBoth = new GridData();
        fillBoth.horizontalAlignment = 4;
        fillBoth.grabExcessHorizontalSpace = true;
        fillBoth.verticalAlignment = 4;
        fillBoth.grabExcessVerticalSpace = true;
        this.systemTree.getTree().setLayoutData((Object)fillBoth);
        this.systemTree.setInput((Object)this);
        this.systemTree.addCheckStateListener(event -> this.setPageComplete(this.validatePage()));
        this.checkSelectedElements();
    }

    private void createDestinationGroup(Composite composite) {
        GridData stretch = new GridData();
        stretch.grabExcessHorizontalSpace = true;
        stretch.horizontalAlignment = 4;
        this.dcc = new DirectoryChooserControl(composite, 0, "Destination: ");
        this.dcc.addDirectoryChangedListener(newDirectory -> {
            this.saveDir(newDirectory);
            this.setPageComplete(this.validatePage());
        });
        this.dcc.setLayoutData((Object)stretch);
        this.loadDir();
    }

    private void createSelectionLibrariesGroup(Composite composite) {
        Group librariesGroup = new Group(composite, 0);
        librariesGroup.setText("Include the following libraries in exported FMU");
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.win32Field = new Button((Composite)librariesGroup, 32);
        this.win64Field = new Button((Composite)librariesGroup, 32);
        this.linux32Field = new Button((Composite)librariesGroup, 32);
        this.linux64Field = new Button((Composite)librariesGroup, 32);
        this.storeSelectedLibaries = new Button((Composite)librariesGroup, 32);
        Button[] buttons = new Button[]{this.win32Field, this.win64Field, this.linux32Field, this.linux64Field, this.storeSelectedLibaries};
        String[] preferences = new String[]{"win32", "win64", "linux32", "linux64", "Save selected libraries for future FMU exports"};
        int i = 0;
        while (i < buttons.length) {
            buttons[i].setText(preferences[i]);
            buttons[i].setEnabled(false);
            buttons[i].setSelection(false);
            ++i;
        }
        this.storeSelectedLibaries.setEnabled(true);
        for (String found : FMUPreferencePage.getFoundLibraries()) {
            if (found.equals("win32")) {
                this.win32Field.setEnabled(true);
                continue;
            }
            if (found.equals("win64")) {
                this.win64Field.setEnabled(true);
                continue;
            }
            if (found.equals("linux32")) {
                this.linux32Field.setEnabled(true);
                continue;
            }
            if (!found.equals("linux64")) continue;
            this.linux64Field.setEnabled(true);
        }
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateFMUWizardPage.this.setPageComplete(CreateFMUWizardPage.this.validatePage());
            }
        };
        int i2 = 0;
        while (i2 < buttons.length) {
            buttons[i2].setSelection(Activator.getDefault().getPreferenceStore().getBoolean(preferences[i2]));
            buttons[i2].addSelectionListener((SelectionListener)listener);
            ++i2;
        }
        librariesGroup.setLayoutData((Object)gridData);
        librariesGroup.setLayout((Layout)gridLayout);
    }

    private boolean validatePage() {
        if ("".equals(this.dcc.getDirectory())) {
            this.setErrorMessage("Destination not selected!");
            return false;
        }
        if (this.systemTree.getCheckedElements().length == 0) {
            this.setErrorMessage("Nothing selected for FMU generation!");
            return false;
        }
        if (!this.isSomeLibrarySelected()) {
            this.setErrorMessage("No libraries selected to include");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean isSomeLibrarySelected() {
        return this.isSelected(this.win32Field) || this.isSelected(this.win64Field) || this.isSelected(this.linux32Field) || this.isSelected(this.linux64Field);
    }

    private boolean isSelected(Button toCheck) {
        return toCheck.isEnabled() && toCheck.getSelection();
    }

    private void loadDir() {
        String cachedDir;
        if (this.getDialogSettings() != null && (cachedDir = this.getDialogSettings().get(CURRENT_DIR_SETTING_ID)) != null) {
            this.setDirectory(cachedDir);
        }
    }

    public void setDirectory(String dir) {
        this.dcc.setDirectory(dir);
    }

    public String getDirectory() {
        return this.dcc.getDirectory();
    }

    private void saveDir(String currentDir) {
        this.getDialogSettings().put(CURRENT_DIR_SETTING_ID, currentDir);
    }

    private void checkSelectedElements() {
        Object[] objectArray = this.selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof AutomationSystem) {
                this.expandSystem((AutomationSystem)obj);
            } else if (obj instanceof Device) {
                this.expandDevice((Device)obj);
            } else if (obj instanceof Resource) {
                this.expandResource((Resource)obj);
            }
            ++n2;
        }
        this.systemTree.setSelection((ISelection)this.selection);
        this.systemTree.setCheckedElements(this.selection.toArray());
    }

    private void expandResource(Resource obj) {
        this.expandDevice(obj.getDevice());
    }

    private void expandDevice(Device obj) {
        this.expandSystem(obj.getAutomationSystem());
        this.systemTree.setExpandedState((Object)obj, true);
    }

    private void expandSystem(Object obj) {
        this.systemTree.setExpandedState(obj, true);
    }
}

