/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.util.TypeListPatternFilter;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;

public class FBPaletteViewer
extends PaletteViewer {
    private CommonViewer commonViewer;
    private PatternFilter patternFilter = null;
    private final String navigatorId;
    private Object[] expandedElements;

    public FBPaletteViewer(String navigatorId) {
        this.navigatorId = navigatorId;
    }

    public void createTypeLibTreeControl(Composite parent, IProject project) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        container.setLayout((Layout)layout);
        final Text text = new Text(container, 384);
        text.setLayoutData((Object)new GridData(768));
        text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    FBPaletteViewer.this.setSearchFilter("");
                } else {
                    FBPaletteViewer.this.setSearchFilter(text.getText());
                }
            }
        });
        text.addModifyListener(e -> this.setSearchFilter(text.getText()));
        this.createCommonViewer(container, project);
        this.setControl((Control)container);
        this.setupResourceChangeListener(project);
    }

    private void createCommonViewer(Composite container, IProject project) {
        this.commonViewer = new CommonViewer(this.navigatorId, container, 772);
        INavigatorContentService contentService = NavigatorContentServiceFactory.INSTANCE.createContentService(this.navigatorId, (StructuredViewer)this.commonViewer);
        contentService.createCommonContentProvider();
        contentService.createCommonLabelProvider();
        INavigatorFilterService filterService = this.commonViewer.getNavigatorContentService().getFilterService();
        ViewerFilter[] visibleFilters = filterService.getVisibleFilters(true);
        int i = 0;
        while (i < visibleFilters.length) {
            this.commonViewer.addFilter(visibleFilters[i]);
            ++i;
        }
        this.commonViewer.setSorter((ViewerSorter)new CommonViewerSorter());
        this.commonViewer.addFilter((ViewerFilter)new TypeListPatternFilter());
        this.commonViewer.getControl().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FBPaletteViewer.this.commonViewer.getControl().forceFocus();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        if (project.getName().equals("Tool Library")) {
            this.commonViewer.setInput((Object)TypeLibrary.getToolLibFolder());
        } else {
            this.commonViewer.setInput((Object)project);
        }
        GridData fillBoth = new GridData(4, 4, true, true);
        this.commonViewer.getControl().setLayoutData((Object)fillBoth);
    }

    private void setSearchFilter(String string) {
        if (this.patternFilter == null) {
            this.patternFilter = new TypeListPatternFilter();
            this.commonViewer.addFilter((ViewerFilter)this.patternFilter);
        }
        this.patternFilter.setPattern(string);
        this.commonViewer.refresh(false);
        this.handleTreeExpansion(string);
    }

    private void handleTreeExpansion(String string) {
        if (!string.isEmpty()) {
            if (this.expandedElements == null) {
                this.expandedElements = this.commonViewer.getExpandedElements();
            }
            this.commonViewer.expandAll();
        } else {
            this.commonViewer.setExpandedElements(this.expandedElements);
            this.expandedElements = null;
        }
    }

    protected void hookControl() {
    }

    private void setupResourceChangeListener(final IProject project) {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                IResourceDelta rootDelta = event.getDelta();
                IResourceDelta docDelta = rootDelta.findMember(project.getFullPath());
                if (docDelta == null) {
                    return;
                }
                Display.getDefault().asyncExec(() -> {
                    if (FBPaletteViewer.this.commonViewer != null && !FBPaletteViewer.this.commonViewer.getControl().isDisposed()) {
                        FBPaletteViewer.this.commonViewer.refresh();
                    }
                });
            }
        });
    }
}

