/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDiagramEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.systemconfiguration.policies.SystemConfXYLayoutEditPolicy;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class SystemNetworkEditPart
extends AbstractDiagramEditPart {
    private EContentAdapter adapter;

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(10));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        f.setOpaque(false);
        return f;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().eAdapters().add((Object)this.getContentAdapter());
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
        }
    }

    public EContentAdapter getContentAdapter() {
        if (this.adapter == null) {
            this.adapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    int type = notification.getEventType();
                    switch (type) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            SystemNetworkEditPart.this.refreshChildren();
                            break;
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SystemConfXYLayoutEditPolicy());
    }

    public SystemConfiguration getModel() {
        return (SystemConfiguration)super.getModel();
    }

    protected List getModelChildren() {
        ArrayList<? extends EObject> children = new ArrayList<EObject>();
        children.addAll((Collection<? extends EObject>)this.getModel().getDevices());
        children.addAll((Collection<? extends EObject>)this.getModel().getSegments());
        children.addAll(SystemNetworkEditPart.getDeviceInputValues((EList<Device>)this.getModel().getDevices()));
        return children;
    }

    private static List<? extends EObject> getDeviceInputValues(EList<Device> devices) {
        ArrayList<Value> children = new ArrayList<Value>();
        for (Device dev : devices) {
            for (VarDeclaration varDecl : dev.getVarDeclarations()) {
                if (varDecl.getValue() == null) continue;
                children.add(varDecl.getValue());
            }
        }
        return children;
    }
}

