/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtester;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.fbtester.model.testdata.TestData;
import org.eclipse.fordiac.ide.fbtester.model.testdata.TestdataFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.IFBTestConfiguration;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.IFBTestConfiguratonCreator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.TestDataEditingSupport;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.TestingManager;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.editparts.FBInterfaceEditPartFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.TestDataLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.TestElement;
import org.eclipse.fordiac.ide.gef.ZoomUndoRedoContextMenuProvider;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.ruler.FordiacRulerComposite;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class FBTester
extends GraphicalEditor
implements IFBTEditorPart {
    public static final String EXPECTED_EVENTS = "ExpectedEvents";
    public static final String EVENT = "Event";
    public static final String NAME = "Name";
    public static final String COLUMN_TYPE = "ColumnType";
    public static final String INPUT_VARIABLE = "InputVariable";
    public static final String OUTPUT_VARIABLE = "OutputVariable";
    private FBType type;
    private String path;
    private KeyHandler sharedKeyHandler;
    private StackLayout stack;
    private Palette palette;
    private final Map<String, IFBTestConfiguration> configurations = new HashMap<String, IFBTestConfiguration>();
    private Composite configurationParent;
    private TableViewer testDataViewer;
    private CommandStack commandStack;
    private final Map<String, TableColumn> dataColumns = new HashMap<String, TableColumn>();
    private final List<TestData> testDataCollection = new ArrayList<TestData>();
    private EContentAdapter eContentAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            FBTester.this.testDataViewer.refresh();
        }
    };

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        if (input instanceof FBTypeEditorInput) {
            FBTypeEditorInput untypedInput = (FBTypeEditorInput)input;
            this.type = untypedInput.getContent();
            PaletteGroup group = untypedInput.getPaletteEntry().getGroup();
            while (group.eContainer() != null) {
                group = group.eContainer();
            }
            if (group instanceof Palette) {
                this.palette = (Palette)group;
            }
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setEditDomain((DefaultEditDomain)new FBTypeEditDomain((IEditorPart)this, this.commandStack));
        this.setPartName("FBTester");
        this.setTitleImage(FordiacImage.ICON_FB_TESTER.getImage());
        super.init(site, input);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        SashForm s = new SashForm(parent, 66048);
        Composite interfaceEditing = new Composite((Composite)s, 2048);
        interfaceEditing.setLayout((Layout)new GridLayout(2, false));
        Label testConfiguraionLabel = new Label(interfaceEditing, 0);
        testConfiguraionLabel.setText("Test Configuration");
        CCombo configurationCombo = ComboBoxWidgetFactory.createCombo((Composite)interfaceEditing);
        configurationCombo.setItems(FBTester.getTestConfigurations().toArray(new String[0]));
        GridData configurationComboData = new GridData(4, 128, false, false);
        configurationCombo.setLayoutData((Object)configurationComboData);
        configurationCombo.addListener(13, event -> {
            IFBTestConfiguration testConfiguration = this.configurations.get(configurationCombo.getText());
            this.stack.topControl = testConfiguration.getControl();
            this.configurationParent.layout();
        });
        GridData configurationParentData = new GridData(4, 4, true, true);
        configurationParentData.horizontalSpan = 2;
        this.configurationParent = new Group(interfaceEditing, 0);
        this.stack = new StackLayout();
        this.configurationParent.setLayout((Layout)this.stack);
        this.configurationParent.setLayoutData((Object)configurationParentData);
        this.createTestConfigurations(this.configurationParent);
        SashForm horizontal = new SashForm((Composite)s, 65792);
        Composite testData = new Composite((Composite)horizontal, 0);
        testData.setLayout((Layout)new GridLayout(1, true));
        this.createTestData(testData);
        Composite graphicalEditor = new Composite((Composite)horizontal, 0);
        graphicalEditor.setLayout((Layout)new FillLayout());
        s.setWeights(new int[]{30, 70});
        horizontal.setWeights(new int[]{50, 50});
        super.createPartControl(graphicalEditor);
    }

    private void createTestData(Composite parent) {
        this.createTestToolbar(parent);
        this.testDataViewer = TableWidgetFactory.createTableViewer((Composite)parent, (int)32);
        this.testDataViewer.addDoubleClickListener(event -> {
            IStructuredSelection selection;
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof TestData) {
                TestData data = (TestData)selection.getFirstElement();
                for (Map.Entry<String, TestElement> entry : TestingManager.getInstance().getTestElements(this.type).entrySet()) {
                    String value = data.getValueFor(entry.getValue().getPortString());
                    if (value == null) continue;
                    entry.getValue().setValue(value);
                }
                TestElement eventToTrigger = null;
                for (Map.Entry<String, TestElement> entry : TestingManager.getInstance().getTriggerElements(this.type).entrySet()) {
                    if (!entry.getValue().getInterfaceElement().getName().equals(data.getEvent().getName())) continue;
                    eventToTrigger = entry.getValue();
                }
                if (eventToTrigger != null) {
                    eventToTrigger.sendEvent();
                }
            }
        });
        this.configureTableLayout();
        if (this.type != null && this.type.getInterfaceList() != null) {
            this.createInputVariableColumns(this.testDataViewer, (List<VarDeclaration>)this.type.getInterfaceList().getInputVars());
            this.createOutputVariableColumns(this.testDataViewer, (List<VarDeclaration>)this.type.getInterfaceList().getOutputVars());
        }
        this.parseTestData();
        this.testDataViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return FBTester.this.testDataCollection.toArray();
            }
        });
        this.testDataViewer.setLabelProvider((IBaseLabelProvider)new TestDataLabelProvider(this.type, this.testDataViewer.getTable()));
        this.testDataViewer.setInput(new Object());
        MenuManager popupMenu = new MenuManager();
        NewTestDataAction newRowAction = new NewTestDataAction();
        popupMenu.add((IAction)newRowAction);
        SaveTestDataAction saveAction = new SaveTestDataAction();
        popupMenu.add((IAction)saveAction);
        Menu menu = popupMenu.createContextMenu((Control)this.testDataViewer.getTable());
        this.testDataViewer.getTable().setMenu(menu);
    }

    private void createTestToolbar(Composite parent) {
        ToolBar tb = new ToolBar(parent, 0x800100);
        ToolItem runItem = new ToolItem(tb, 0);
        runItem.setToolTipText("Run selected Tests");
        runItem.setImage(FordiacImage.ICON_RUN_DEBUG.getImage());
        ToolItem stopItem = new ToolItem(tb, 0);
        stopItem.setToolTipText("Stop");
        stopItem.setImage(FordiacImage.ICON_STOP.getImage());
        ToolItem saveItem = new ToolItem(tb, 0);
        saveItem.setToolTipText("Save Test Data");
        saveItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVE_EDIT"));
        saveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FBTester.this.saveTestData();
            }
        });
        ToolItem addItem = new ToolItem(tb, 0);
        addItem.setToolTipText("Add Test");
        addItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FBTester.this.addTest();
            }
        });
        ToolItem deleteItem = new ToolItem(tb, 0);
        deleteItem.setToolTipText("Delete Test");
        deleteItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((StructuredSelection)FBTester.this.testDataViewer.getSelection()).getFirstElement();
                FBTester.this.testDataCollection.remove(selection);
                FBTester.this.testDataViewer.refresh();
            }
        });
    }

    private void configureTableLayout() {
        TableViewerColumn nameColumn = new TableViewerColumn(this.testDataViewer, 16384);
        nameColumn.getColumn().setWidth(80);
        nameColumn.getColumn().setText(NAME);
        nameColumn.getColumn().setData(COLUMN_TYPE, (Object)NAME);
        nameColumn.setEditingSupport((EditingSupport)new TestDataEditingSupport((ColumnViewer)this.testDataViewer, nameColumn.getColumn()));
        TableViewerColumn eventCol = new TableViewerColumn(this.testDataViewer, 16384);
        eventCol.getColumn().setWidth(80);
        eventCol.getColumn().setText(EVENT);
        eventCol.getColumn().setData(COLUMN_TYPE, (Object)EVENT);
        TableViewerColumn expectedEvents = new TableViewerColumn(this.testDataViewer, 16384);
        expectedEvents.getColumn().setWidth(100);
        expectedEvents.getColumn().setText("Expected Events");
        expectedEvents.getColumn().setData(COLUMN_TYPE, (Object)EXPECTED_EVENTS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveTestData() {
        if (this.path == null) return;
        File testDataFile = new File(String.valueOf(this.path) + File.separatorChar + this.type.getName() + ".forte");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream outStream = new FileOutputStream(testDataFile);
                try {
                    block22: {
                        DataOutputStream dataStream = new DataOutputStream(outStream);
                        try {
                            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(dataStream));){
                                Iterator<TestData> iterator = this.testDataCollection.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        writer.flush();
                                        break;
                                    }
                                    TestData testData = iterator.next();
                                    writer.write(testData._getLine());
                                    writer.newLine();
                                }
                            }
                            if (dataStream == null) break block22;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (dataStream == null) throw throwable;
                            dataStream.close();
                            throw throwable;
                        }
                        dataStream.close();
                    }
                    if (outStream == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (outStream == null) throw throwable;
                    outStream.close();
                    throw throwable;
                }
                outStream.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseTestData() {
        if (this.path == null) return;
        File testDataFile = new File(String.valueOf(this.path) + File.separatorChar + this.type.getName() + ".forte");
        if (!testDataFile.exists()) return;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream fstream = new FileInputStream(testDataFile);
                try {
                    block21: {
                        DataInputStream in = new DataInputStream(fstream);
                        try {
                            try (BufferedReader data = new BufferedReader(new InputStreamReader(in));){
                                String line;
                                while ((line = data.readLine()) != null) {
                                    TestData testData = this.createTestData(line);
                                    this.testDataCollection.add(testData);
                                }
                            }
                            if (in == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (in == null) throw throwable;
                            in.close();
                            throw throwable;
                        }
                        in.close();
                    }
                    if (fstream == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fstream == null) throw throwable;
                    fstream.close();
                    throw throwable;
                }
                fstream.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    private TestData createTestData(String line) {
        TestData testData = TestdataFactory.eINSTANCE.createTestData();
        testData.eAdapters().add((Object)this.eContentAdapter);
        testData.setType(this.type);
        testData.setLine(line);
        return testData;
    }

    private void createInputVariableColumns(TableViewer testData, List<VarDeclaration> list) {
        for (VarDeclaration input : list) {
            TableViewerColumn column = new TableViewerColumn(testData, 16384);
            column.getColumn().setWidth(40);
            column.getColumn().setText(input.getName());
            column.getColumn().setData(COLUMN_TYPE, (Object)INPUT_VARIABLE);
            column.getColumn().setData(INPUT_VARIABLE, (Object)input);
            column.setEditingSupport((EditingSupport)new TestDataEditingSupport((ColumnViewer)this.testDataViewer, column.getColumn()));
            this.dataColumns.put(input.getName(), column.getColumn());
        }
    }

    private void createOutputVariableColumns(TableViewer testData, List<VarDeclaration> list) {
        for (VarDeclaration output : list) {
            TableViewerColumn column = new TableViewerColumn(testData, 16384);
            column.getColumn().setWidth(40);
            column.getColumn().setText(output.getName());
            column.getColumn().setData(COLUMN_TYPE, (Object)OUTPUT_VARIABLE);
            column.getColumn().setData(OUTPUT_VARIABLE, (Object)output);
            column.setEditingSupport((EditingSupport)new TestDataEditingSupport((ColumnViewer)this.testDataViewer, column.getColumn()));
            this.dataColumns.put(output.getName(), column.getColumn());
        }
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.getEditorInput());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ZoomScalableFreeformRootEditPart root = new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry());
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory((EditPartFactory)this.getEditpartFactory());
        ZoomUndoRedoContextMenuProvider cmProvider = new ZoomUndoRedoContextMenuProvider((EditPartViewer)viewer, root.getZoomManager(), this.getActionRegistry()){

            public void buildContextMenu(IMenuManager menu) {
                super.buildContextMenu(menu);
                IAction action = this.getRegistry().getAction((Object)ActionFactory.DELETE.getId());
                menu.appendToGroup("org.eclipse.gef.group.copy", action);
            }
        };
        viewer.setContextMenu((MenuManager)cmProvider);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        KeyHandler viewerKeyHandler = new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler());
        viewer.setKeyHandler(viewerKeyHandler);
    }

    public ZoomManager getZoomManger() {
        return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
    }

    protected FBInterfaceEditPartFactory getEditpartFactory() {
        return new FBInterfaceEditPartFactory(this, this.palette, this.getZoomManger());
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'+', (int)61, (int)262144), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        }
        return this.sharedKeyHandler;
    }

    protected void createGraphicalViewer(Composite parent) {
        FordiacRulerComposite rulerComp = new FordiacRulerComposite(parent, 0);
        super.createGraphicalViewer((Composite)rulerComp);
        rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    public static List<String> getTestConfigurations() {
        ArrayList<String> testConfigurations = new ArrayList<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.fordiac.ide.fbtypeeditor.fbtester.fbTesterConfiguration");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object obj = element.createExecutableExtension("class");
                    if (obj instanceof IFBTestConfiguratonCreator) {
                        String label = element.getAttribute("label");
                        testConfigurations.add(label);
                    }
                }
                catch (Exception exception) {}
                ++n4;
            }
            ++n2;
        }
        return testConfigurations;
    }

    public void createTestConfigurations(Composite parent) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.fordiac.ide.fbtypeeditor.fbtester.fbTesterConfiguration");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object obj = element.createExecutableExtension("class");
                    if (obj instanceof IFBTestConfiguratonCreator) {
                        ((IFBTestConfiguratonCreator)obj).setType(this.type);
                        ((IFBTestConfiguratonCreator)obj).setGroup(this.palette.getRootGroup());
                        IFBTestConfiguration configuration = ((IFBTestConfiguratonCreator)obj).createConfigurationPage(parent);
                        String lang = element.getAttribute("label");
                        this.configurations.put(lang, configuration);
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                ++n4;
            }
            ++n2;
        }
    }

    void addTest() {
        StringBuilder dataLine = new StringBuilder("Testname;");
        dataLine.append(this.type.getName());
        dataLine.append(";");
        if (!this.type.getInterfaceList().getEventInputs().isEmpty()) {
            Event event = (Event)this.type.getInterfaceList().getEventInputs().get(0);
            dataLine.append(event.getWith().size()).append(";");
            for (With with : event.getWith()) {
                VarDeclaration var = with.getVariables();
                dataLine.append(var.getName()).append(";val;");
            }
            dataLine.append(event.getName()).append(";");
        }
        if (!this.type.getInterfaceList().getEventOutputs().isEmpty()) {
            dataLine.append("1;");
            dataLine.append(((Event)this.type.getInterfaceList().getEventOutputs().get(0)).getName());
            dataLine.append(";");
        } else {
            dataLine.append("0;");
        }
        if (!this.type.getInterfaceList().getOutputVars().isEmpty()) {
            dataLine.append(this.type.getInterfaceList().getOutputVars().size());
            dataLine.append(";");
            for (VarDeclaration var : this.type.getInterfaceList().getOutputVars()) {
                dataLine.append(var.getName()).append(";val;");
            }
        }
        TestData testData = this.createTestData(dataLine.toString());
        this.testDataCollection.add(testData);
        this.testDataViewer.refresh();
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        return false;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    private class NewTestDataAction
    extends Action {
        public NewTestDataAction() {
            super("New Test");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        }

        public void run() {
            FBTester.this.addTest();
        }
    }

    private class SaveTestDataAction
    extends Action {
        public SaveTestDataAction() {
            super("Save Testdata");
        }

        public void run() {
            FBTester.this.saveTestData();
        }
    }
}

