/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtester.editparts;

import java.util.Set;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.SpecificLayerEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.TestingManager;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.TestElement;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.policies.SetTestValueEditPolicy;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class TestEditPart
extends AbstractViewEditPart
implements SpecificLayerEditPart {
    private InterfaceEditPart parentPart;
    protected int oldx;
    protected int oldy;

    public InterfaceEditPart getParentPart() {
        return this.parentPart;
    }

    public void activate() {
        super.activate();
        Set set = this.getViewer().getEditPartRegistry().keySet();
        for (Object object : set) {
            EditPart part;
            if (!(object instanceof IInterfaceElement) || !((IInterfaceElement)object).equals(this.getModel().getInterfaceElement()) || !((part = (EditPart)this.getViewer().getEditPartRegistry().get(object)) instanceof InterfaceEditPart)) continue;
            this.parentPart = (InterfaceEditPart)part;
            IFigure f = this.parentPart.getFigure();
            f.addAncestorListener(new AncestorListener(){

                public void ancestorRemoved(IFigure ancestor) {
                }

                public void ancestorMoved(IFigure ancestor) {
                    TestEditPart.this.refreshPosition();
                }

                public void ancestorAdded(IFigure ancestor) {
                }
            });
        }
        this.updatePos();
        this.registerElement();
    }

    public void setBackgroundColor(Color color) {
        this.getFigure().setBackgroundColor(color);
    }

    protected void refreshName() {
        this.getNameLabel().setText(this.getModel().getValue());
        this.getNameLabel().setToolTip((IFigure)new Label(this.getModel().getValue()));
    }

    protected void registerElement() {
        TestingManager.getInstance().addTestElement(this.getModel());
    }

    public boolean isInput() {
        return this.getModel().getInterfaceElement().isIsInput();
    }

    public boolean isEvent() {
        return this.getModel().getInterfaceElement() instanceof Event;
    }

    public boolean isVariable() {
        return this.getModel().getInterfaceElement() instanceof VarDeclaration;
    }

    protected void updatePos() {
        if (this.parentPart != null) {
            String label = ((Label)this.getFigure()).getText();
            Rectangle bounds = this.parentPart.getFigure().getBounds();
            int x = 0;
            if (this.isInput()) {
                Font font = ((Label)this.getFigure()).getFont();
                int width = 50;
                if (font != null) {
                    width = FigureUtilities.getTextWidth((String)label, (Font)this.getFigure().getFont());
                    width = Math.max(width, this.getFigure().getBounds().width);
                }
                x = bounds.x - 10 - width - 15 * this.getModel().getFb().getInterface().getEventInputs().size();
            } else {
                x = bounds.x + bounds.width + 10 + 15 * this.getModel().getFb().getInterface().getEventInputs().size();
            }
            int y = bounds.y;
            if (x != this.oldx || y != this.oldy) {
                this.getModel().setX(x);
                this.getModel().setY(y);
                this.oldx = x;
                this.oldy = y;
            }
        }
    }

    public TestElement getModel() {
        return (TestElement)((Object)super.getModel());
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new SetTestValueEditPolicy());
    }

    protected IFigure createFigureForModel() {
        Label l = new Label();
        l.setSize(100, 100);
        l.setOpaque(true);
        l.setBackgroundColor(ColorConstants.yellow);
        l.setPreferredSize(150, 20);
        l.setBorder((Border)new MarginBorder(3, 5, 3, 5));
        if (this.isInput()) {
            LineBorder lb = new LineBorder(){

                public Insets getInsets(IFigure figure) {
                    return new Insets(3, 5, 3, 5);
                }
            };
            l.setBorder((Border)lb);
        }
        l.setText("--");
        return l;
    }

    protected EContentAdapter createContentAdapter() {
        return new EContentAdapter(){
            private boolean blockAdapter;

            public void notifyChanged(Notification notification) {
                if (!this.blockAdapter) {
                    this.blockAdapter = true;
                    super.notifyChanged(notification);
                    TestEditPart.this.refreshVisuals();
                    this.blockAdapter = false;
                }
            }
        };
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshPosition();
    }

    protected void refreshPosition() {
        this.updatePos();
        Rectangle bounds = null;
        if (this.getModel() != null) {
            bounds = new Rectangle(this.getModel().getX(), this.getModel().getY(), 80, -1);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
        }
    }

    public boolean understandsRequest(Request request) {
        if (request.getType() == "move") {
            return false;
        }
        if (request.getType() == "direct edit" || request.getType() == "open") {
            return this.isInput();
        }
        return super.understandsRequest(request);
    }

    public void performRequest(Request request) {
        if (!(request.getType() != "direct edit" && request.getType() != "open" || this.isInput())) {
            return;
        }
        super.performRequest(request);
    }

    public INamedElement getINamedElement() {
        return this.getModel().getInterfaceElement();
    }

    public Label getNameLabel() {
        return (Label)this.getFigure();
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        return null;
    }

    public String getSpecificLayer() {
        return "TOPLAYER";
    }

    public void setValue(String string) {
        if (this.isActive() && this.getFigure() != null) {
            ((Label)this.getFigure()).setText(string);
        }
    }
}

